#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

CMD = '/opt/NETAwss/mgmt/ws_retry smtp'
stdout = ""
stderr = ""

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		cmd = CMD
		
		# transform the list of IDs ('m1.rmd,m2.rmd') into a list of arguments for ws_retry ('m1 m2')
		msgs =	ctxt.xpathEval("/command/arg[@name='messages']/@value")
		if len(msgs) == 1:
			msgs = msgs[0].content.replace('.rmd','').replace(',', ' ')
			cmd += ' ' + msgs
	
		# let's go
		Trace("Launching '%s'" % cmd)
		res = libwsa.RunCmd(cmd, ScriptCallback)
		Trace("Done!")
		if res != 0:
			print script
			print res
			libwsa.PrintErrorBase(_TR_("WSRETR_FAILED", 'The retry failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSQuRetry" id="1">
	<arg name="messages" value="2b3c4756_91f3_11d8_80e5_000347c26035.rmd,2f0affda_91f3_11d8_9da5_000347c26035.rmd"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
