#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, zipfile
from tempfile import mkdtemp, mkstemp
from shutil import copyfile, rmtree
from libwsa import _TR_, Trace, NewGetStatusOutput

libwsa.do_trace = False
formatXML = False
	
CMD = "/opt/NETAwss/mgmt/restore_config '%s' '%s'"

def Run():
	try:
		dtemp = None
		tmpfiles = []
		try:
			####################################
			# parse the arguments
			####################################
			args, params = libwsa.Init()
			p_ctxt = params.xpathNewContext()
			a_ctxt = args.xpathNewContext()
	
			####################################
			# get the input file
			####################################
			input_file = a_ctxt.xpathEval("/command/arg[@name='file']/@ref")
			if len(input_file) != 1:
				raise RuntimeError, _TR_("WRC_FMS", 'Missing or invalid "file" argument')
			input_file = input_file[0].content
				
			####################################
			# get the list of file to restore
			####################################
			# [ name, path, tmp_file ]
			IDX_NAME = 0
			IDX_PATH = 1
			IDX_TMP = 2
			files_out = [ [f.prop('name'), f.prop('path'), None] for f in p_ctxt.xpathEval("/params/param[@name='file-list']/file")]

			####################################
			# Create a temporary directory 
			####################################
			dtemp = mkdtemp(dir=libwsa.tmp_dir)

			####################################
			# Launch the script
			####################################
			cmd = CMD % (input_file, dtemp)
			Trace("Launching '%s'" % cmd)
			status, output = NewGetStatusOutput(cmd)
			Trace('Done')
			if status != 0:
				raise RuntimeError, _TR_("WRC_RCFAIL", "The restoration of the configuration failed")
				
			####################################
			# Now move the "desired files" out of the tree
			####################################
			for f in files_out:
				wf = os.path.join(dtemp, f[IDX_PATH][1:])
				if os.path.isfile(wf):
					(fd, tmppath) = mkstemp(prefix='rc.', suffix='.tmp', dir=libwsa.tmp_dir)
					os.close(fd)
					tmpfiles.append(tmppath)
					copyfile(wf, tmppath)
					os.chmod(tmppath,  0777)
					os.unlink(wf)
					f[IDX_TMP] = tmppath
			
			####################################
			# Zip the rest
			####################################
			def buildZip(args, directory, names):
				zip = args[0]
				basedir = args[1]
				for f in names:
					path = os.path.join(directory, f)
					if os.path.isfile(path):
						zip.write(path, path[len(basedir)+1:])
			
			zipothers = None
			zipobj = None
			try:
				(fd, zipothers) = mkstemp(suffix='.zip', prefix='rc.', dir=libwsa.tmp_dir)
				os.close(fd)
				tmpfiles.append(zipothers)
				zipobj = zipfile.ZipFile(zipothers, "w")
				os.path.walk(dtemp, buildZip, (zipobj, dtemp))
			finally:
				if zipobj is not None:
					zipobj.close()
					os.chmod(zipothers,  0777)

			####################################
			# reply
			####################################
			# construct the reply
			reply = libxml2.newDoc("1.0")
			root = reply.newChild(None, "res", None)
			root.setProp("status", "0")
			for f in files_out:
				if f[IDX_TMP] is not None:
					elt = root.newChild(None, "output", None)
					elt.setProp("name", "file")
					elt.setProp("value", f[IDX_NAME])
					elt.setProp("status", "1")
					elt.setProp("ref", f[IDX_TMP])
			elt = root.newChild(None, "output", None)
			elt.setProp("name", "others")
			elt.setProp("value", "zip")
			elt.setProp("status", "1")
			elt.setProp("ref", zipothers)
			# we're done!
			print root.serialize(format=formatXML)
			sys.exit(0)
		finally:
			if dtemp is not None:
				rmtree(dtemp, True)
	except SystemExit:
		pass
	except:
		for f in tmpfiles:
			try:
				os.unlink(f)
			except:
				pass
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
			

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSRestoreConfig" id="1">
	<arg name="file" ref="/tmp/wsa/toto"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="file-list">
		<file name="machine" path="/config/wsxmlconf/machine.xml"/>
		<file name="network" path="/config/wsxmlconf/network.xml"/>
		<file name="system" path="/config/wsxmlconf/system.xml"/>
		<file name="smtp" path="/config/wsxmlconf/smtp.xml"/>
		<file name="http" path="/config/wsxmlconf/http.xml"/>
		<file name="ftp" path="/config/wsxmlconf/ftp.xml"/>
		<file name="pop3" path="/config/wsxmlconf/pop3.xml"/>
		<file name="loadsharing" path="/config/wsxmlconf/ls.xml"/>
		<file name="rules" path="/config/wsxmlconf/rules.xml"/>
		<file name="identities" path="/config/wsxmlconf/identities.xml"/>
		<file name="channels" path="/config/wsxmlconf/channels.xml"/>
		<file name="smtp-logging" path="/config/wsxmlconf/smtp-logging.xml"/>
		<file name="http-logging" path="/config/wsxmlconf/http-logging.xml"/>
		<file name="ftp-logging" path="/config/wsxmlconf/ftp-logging.xml"/>
		<file name="pop3-logging" path="/config/wsxmlconf/pop3-logging.xml"/>
		<file name="ui_settings" path="/config/wsxmlconf/ui_settings.xml"/>
		<file name="appliances" path="/config/wsxmlconf/appliances.xml"/>
	</param>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
