#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re
from libwsa import _TR_
from libwsa import Trace
from libwsa import NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
PING = "/bin/ping"

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML
	try:
		####################################
		# parse the arguments
		####################################			
		args, params = libwsa.Init()

		a_ctxt = args.xpathNewContext()
		p_ctxt = params.xpathNewContext()
		
		cmd = a_ctxt.xpathEval("/command/arg[@name='cmd']/@value")
		if len(cmd) == 1:
			cmd = cmd[0].content
		else:
			raise RuntimeError, _TR_("WSRC_NCD", 'No "command" argument')
	
		cmd_n = p_ctxt.xpathEval("/params/param[@name='cmd-list']/cmd[@name='%s']" % cmd)
		if len(cmd_n) != 1:
			raise RuntimeError, _TR_("WSRC_ICM", "The command '%s' is unknown or defined more than once" % cmd)
		cmd_n = cmd_n[0]

		script = cmd_n.prop("script")
		if script is None:
			raise RuntimeError, _TR_("WSRC_MSA", "The 'script' attribute of the command '%s' is missing" % cmd)
			
		res_path = cmd_n.prop("output")
		if res_path != None:
			status, res_path = NewGetStatusOutput("/bin/echo -n %s" % res_path)
			if status != 0:
				raise RuntimeError, _TR_("WSRC_UEO", 'Unable to expand the output path')

		res_tmp = cmd_n.prop("tmp_output")
		if res_tmp != None:
			res_tmp = (int(res_tmp) != 0)
		else:
			res_tmp = False

		stdout = ""
		stderr = ""
		Trace("Launching '%s'" % script)
		res = libwsa.RunCmd(script, ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSNP_RCFD", 'The command failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		if (res_path != None):
			elt = root.newChild(None, "output", None)
			elt.setProp("name", "file")
			elt.setProp("ref", res_path)
			if not res_tmp:
				elt.setProp("refdel", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		raise
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSRunCmd" id="1">
	<arg name="cmd" value="test"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="cmd-list">
		<cmd 
			name = "test"
			script="/usr/bin/printf '1\\n2\\n3\\n' >$WSADMIN_TMP_DIR/toto.txt" 
			output="$WSADMIN_TMP_DIR/toto.txt" 
			tmp_output="0"
		/>
	</param>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()

if __name__ == '__main__':
	Run()
