#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, glob, zipfile
from tempfile import mkstemp
from libwsa import _TR_, NewGetStatusOutput

# args
#    vars : xml string
#    params : xml string

libwsa.do_trace = False

def Run():
	# characters that can't be used on MSWin in afilename
	windows_forbidden = '\/:*?"<>|'
	# create a temporary file and close it, this should prevent other script to use the same file
	(fd, tmppath) = mkstemp(suffix='.zip', prefix='logs', dir=libwsa.tmp_dir)
	os.close(fd)

	try:
		####################################
		# Create the zip file
		####################################
		zip = zipfile.ZipFile(tmppath, "w")

		try:
			####################################
			# parse the arguments
			####################################
			args, params = libwsa.Init()

			ctxt = params.xpathNewContext()
			files = ctxt.xpathEval("/params/param[@name='file-list']/files")
			if len(files) == 0:
				raise RuntimeError, _TR_("WSS_FSM", 'Invalid or missing "files" parameters')

			####################################
			# "flush" the remaining events
			####################################
			status, reply = NewGetStatusOutput("/opt/NETAwss/mgmt/webshieldservices.d/10_logging flush")
			
			####################################
			# build the zip file
			####################################
			for child in files:
				# got a pattern
				pat = child.prop("path")
				opath = child.prop("output_path")
				# add each file to the zip file
				for f in glob.glob(pat):
					if os.path.isfile(f) and (not os.path.islink(f)):
						# got a file
						# make sure that its window compatible
						oname = os.path.basename(f)
						for c in windows_forbidden:
							oname = oname.replace(c, "_")
						zip.write(f, os.path.join(opath, oname), zipfile.ZIP_DEFLATED)
			####################################
			# reply
			####################################
			reply = libxml2.newDoc("1.0")
			root = reply.newChild(None, "res", None)
			root.setProp("status", "0")
			elt = root.newChild(None, "output", None)
			elt.setProp("name", "file")
			elt.setProp("ref", tmppath)
			# success so log it
			libwsa.Log("UI_LOGS_SAVED", "LogsSaved")
			# we're done!
			print root.serialize()
		finally:
			zip.close()
			os.chmod(tmppath,  0777)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		os.remove(tmppath)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSSaveLogs" id="1"/>
	"""
	params = \
	"""
<params>
	<param name="file-list">
		<files path="/var/log/*" output_path="sys-logs"/>
		<files path="/var/log/httpd/*" output_path="httpd-logs"/>
		<files path="/logs/xmlchannel/*.xml" output_path="ws-logs"/>
		<files path="/logs/xmlchannel/*.xml.gz" output_path="ws-logs"/>
		<files path="/config/wsxmlconf/spamconfig/*.log" output_path="spam-logs"/>
		<files path="/logs/hotfixes/*" output_path="hf-logs"/>
	</param>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
