#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace
from libwsa import NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

CMD = "(echo /bin/rpm -e '%s' | /usr/bin/wsmount)"

# args
#    vars : xml string
#    params : xml string

def Run():
	####################################
	# parse the arguments
	####################################
	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		# user
		plugin_name = ctxt.xpathEval("/command/arg[@name='plugin']/@value")
		if len(plugin_name) != 1:
			raise _TR_("WUPI_BADNAME", "Invalid plugin parameter")
		plugin_name = plugin_name[0].content

		#let's go
		cmd = CMD % plugin_name
		Trace('exec %s' %cmd)
		status, dirs = NewGetStatusOutput(cmd)
		Trace('Done')
		if status != 0:
			raise RuntimeError, _TR_("WUPI_RPMFAIL", "The uninstallation failed")

		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	
	except SystemExit:
		pass
	except Exception, details:
		libwsa.PrintError(details)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSUninstallPlugin" id="1">
	<arg name="plugin" value="RestoreEmails"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
