#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

I_AV = 0
I_SPAM = 1

I_ENG = 1
I_DAT = 2
I_XDAT = 4

CMDS = [ '/opt/NETAwss/mgmt/av-update -retries 0 ', '/opt/NETAwss/mgmt/spam-update -retries 0 ' ]
CMDS_XTRA = [ '/opt/NETAwss/mgmt/add_extra_dat ', '/opt/NETAwss/mgmt/add_extra_rule ' ]

stdout = ""
stderr = ""

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def String2PartFile(name):
	# no * but allows xdat
	if name == "eng":
		part = I_ENG
	elif name == "dat":
		part = I_DAT
	elif name == "xdat":
		part = I_XDAT
	else:
		raise _TR_("WSUN_BADPART", "Invalid or missing part argument")
	return part

def String2PartServer(name):
	# no xdat but allows *
	if name == "eng":
		part = I_ENG
	elif name == "dat":
		part = I_DAT
	elif name == "*":
		part = I_ENG | I_DAT
	else:
		raise _TR_("WSUN_BADPART", "Invalid or missing part argument")
	return part

def Run():
	global stdout, stderr, formatXML

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		cmd = ''
		
		# AV or SPAM ?
		component =	ctxt.xpathEval("/command/arg[@name='component']/@value")
		if len(component) != 1:
				raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
		component = component[0].content
		if component == "av":
			type = I_AV
		elif component == "spam":
			type = I_SPAM
		else:
			raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
	
		# files or server
		files = ctxt.xpathEval("/command/arg[@name='file']")
		server = ctxt.xpathEval("/command/arg[@name='server']")
		
		if len(server) > 1:
			raise "Only one server argument is allowed"
		if len(server) == 1 and len(files) > 0:
			raise "File and server arguments cannot be mixed"
		if len(server) == 0 and len(files) == 0:
			raise "Need at least a file or server argument"
		
		cmd = CMDS[type]
		
		if len(files) > 0:
			####################
			# file update
			####################
			parts = 0
			for f in files:
				part = String2PartFile(f.prop("part"))
				file = f.prop("ref")
				if len(file ) == 0:
					raise _TR_("WSUN_BADFILEA", "Invalid or missing file argument")
				if part == I_XDAT:
					if len(files) != 1:
						raise "Extra-dat updates cannot be mixed with other updates"
					cmd = CMDS_XTRA[type] + " '" + file + "'"
					break
				if (parts & part) != 0:
					raise "Duplicated part argument"
				parts |= part
				if part == I_ENG:
					cmd += " -engzip"
				else:
					cmd += " -datzip"
				cmd += " '" + file + "'"
		else:
			####################
			# server update
			####################
			server = server[0]
			part = String2PartServer(server.prop("part"))
			
			if (part | I_ENG) != 0:
				cmd += " -eng"
			if (part | I_DAT) != 0:
				cmd += " -dat"

			tmp = server.prop("address")
			if len(tmp) != 0:
				cmd += " -src '"+tmp+"'"
			tmp = server.prop("usr")
			if len(tmp) != 0:
				cmd += " -user '"+tmp+"'"
			tmp = server.prop("pwd")
			if len(tmp) != 0:
				cmd += " -pass '"+tmp+"'"
			tmp = server.prop("dir")
			if len(tmp) != 0:
				cmd += " -srcpath '"+tmp+"'"
			# proxy
			tmp = ctxt.xpathEval("/command/arg[@name='proxy']/@address")
			if len(tmp) == 1 and len(tmp[0].content) != 0:
				cmd += " -proxy '"+tmp[0].content+"'"
			tmp = ctxt.xpathEval("/command/arg[@name='proxy']/@usr")
			if len(tmp) == 1 and len(tmp[0].content) != 0:
				cmd += " -puser '"+tmp[0].content+"'"
			tmp = ctxt.xpathEval("/command/arg[@name='proxy']/@pwd")
			if len(tmp) == 1 and len(tmp[0].content) != 0:
				cmd += " -ppass '"+tmp[0].content+"'"
			tmp = ctxt.xpathEval("/command/arg[@name='proxy']/@port")
			if len(tmp) == 1 and len(tmp[0].content) != 0:
				cmd += " -pport '"+tmp[0].content+"'"
		####################################
		# let's go
		####################################
		Trace("Launching '%s'" % cmd)
		res = libwsa.RunCmd(cmd, ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSUN_FAILED", 'The update failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd_n_a_1 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="av"/>
	<arg name="part" value="dat"/>
	<arg name="server" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" dir="/pub"/>
</command>
	"""
	cmd_n_a_2 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="av"/>
	<arg name="part" value="eng"/>
	<arg name="server" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" dir="/pub"/>
</command>
	"""
	cmd_n_s_1 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="spam"/>
	<arg name="part" value="dat"/>
	<arg name="server" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" dir="/pub"/>
</command>
	"""
	cmd_n_s_2 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="spam"/>
	<arg name="part" value="eng"/>
	<arg name="server" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" dir="/pub"/>
</command>
	"""
	cmd_2 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="av"/>
	<arg name="part" value="eng"/>
	<arg name="server" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" dir="/pub"/>
	<arg name="proxy" address="king.physic.nai.com" usr="anonymous" pwd="anonymous" port="80"/>
</command>
	"""
	cmd_l_a_1 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="av"/>
	<arg name="part" value="dat"/>
	<arg name="file" ref="/root/upd/av/dat-4350.zip"/>
</command>
	"""
	cmd_l_a_2 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="av"/>
	<arg name="part" value="eng"/>
	<arg name="file" ref="/root/upd/av/elnx4320.zip"/>
</command>
	"""
	cmd_l_s_1 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="spam"/>
	<arg name="part" value="dat"/>
	<arg name="file" ref="/root/upd/av/sprul-1.0.2-1.75.zip"/>
</command>
	"""
	cmd_l_s_2 = \
	"""
<command name="WSUpdate" id="1">
	<arg name="component" value="spam"/>
	<arg name="part" value="eng"/>
	<arg name="file" ref="/root/upd/av/speng-1.0.2-1.75.zip"/>
</command>
	"""

	params = \
	"""
<params>
</params>
	"""
	cmd = cmd_l_s_2
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
