<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating the NIC hardware settings for E100 Adapter
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:text>e100_speed_duplex=</xsl:text>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList[@type='NIC']">
	<xsl:call-template name="nicsettings"/>
        <xsl:choose>
	    <xsl:when test="@name='eth0'">
               <xsl:text>,</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="nicsettings">
        <xsl:choose>
	    <xsl:when test="AutoNegotiate/@value='on'">
               <xsl:text>0</xsl:text>
            </xsl:when>
	    <xsl:otherwise>
	        <xsl:call-template name="force_settings"/>
            </xsl:otherwise>
        </xsl:choose>
</xsl:template>

<xsl:template name="force_settings">

        <xsl:choose>
	    <xsl:when test="Speed/@value='10'">
                <xsl:choose>
	            <xsl:when test="Duplex/@value='half'">

                        <xsl:text>1</xsl:text>
                    </xsl:when>
	            <xsl:when test="Duplex/@value='full'">
                        <xsl:text>2</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
	    <xsl:when test="Speed/@value='100'">
                <xsl:choose>
	            <xsl:when test="Duplex/@value='half'">
                        <xsl:text>3</xsl:text>
                    </xsl:when>
	            <xsl:when test="Duplex/@value='full'">
                        <xsl:text>4</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
	    <xsl:when test="Speed/@value='1000'">
                <xsl:choose>
	            <xsl:when test="Duplex/@value='half'">
                        <xsl:text>3</xsl:text>
                    </xsl:when>
	            <xsl:when test="Duplex/@value='full'">
                        <xsl:text>4</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
</xsl:template>

</xsl:stylesheet>

