<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating /etc/hosts
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:variable name="host_name" select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/Attr[@name='IPHostname']/@value"/>
    <xsl:variable name="domain_name" select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/Attr[@name='IPDomainName']/@value"/>

    <xsl:text>127.0.0.1 localhost&#10;</xsl:text>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList/NetObject[@type='NIC']">
        <xsl:choose>
            <xsl:when test="State/@value='on'">
                <xsl:value-of select="Address/@value"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="$host_name"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$domain_name"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="$host_name"/>
                <xsl:text>&#10;</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>
</xsl:stylesheet>

