<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for getting LDAP into text file for proxies
	Copyright (C) 2004 Networks Associates Technology Inc. All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:for-each select="//GlobalSettings[@name='network']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='ldap-settings']">
	<xsl:call-template name="ldapsettings"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="ldapsettings">
    <xsl:for-each select="Bag[@name='LDAPServers']/List">
	<xsl:call-template name="ldapserver"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="ldapserver">
      <xsl:text>server</xsl:text>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>ldapserver </xsl:text>
      <xsl:value-of select="Attr[@name='ServerName']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>type </xsl:text>
      <xsl:value-of select="Attr[@name='ServerType']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>user </xsl:text>
      <xsl:value-of select="Attr[@name='Username']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>password </xsl:text>
      <xsl:value-of select="Attr[@name='Password']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>userquery </xsl:text>
      <xsl:value-of select="Attr[@name='MemberQuery']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>groupquery </xsl:text>
      <xsl:value-of select="Attr[@name='GroupQuery']/@value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:text>base </xsl:text>
      <xsl:value-of select="Attr[@name='BaseDN']/@value"/>
      <xsl:text>&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>

