#!/usr/bin/wsrunxslt /config/wsxmlconf/channels.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for logrotation configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">stop</xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
        </xsl:when>
        <xsl:when test="$param_0='restart'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
     exit 0
</xsl:template>

<xsl:template name="set_config">
    <xsl:variable name="period" select="//ReportingConfig/Channel[@name='xml']/Default/@age"/>
    <xsl:choose>
	<xsl:when test="$period=''">
		<xsl:call-template name="logrotate">
                    <xsl:with-param name="period">14</xsl:with-param>
		</xsl:call-template>
        </xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="logrotate">
                    <xsl:with-param name="period"><xsl:value-of select="$period"/></xsl:with-param>
		</xsl:call-template>
	</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="logrotate">
<xsl:param name="period"/>
<xsl:text>cat &gt;/etc/logrotate.conf&lt;&lt;-END
# Generated by Webshield Appliance Configuration
# This file should not be manually edited
daily

rotate </xsl:text><xsl:value-of select="$period"/><xsl:text>

# send errors to root
# errors root

# create new (empty) log files after rotating old ones
create

# uncomment this if you want your log files compressed
compress

# RPM packages drop log rotation information into this directory
include /etc/logrotate.d

# no packages own lastlog or wtmp -- we'll rotate them here
/var/log/wtmp {
    daily
    create 0664 root utmp
    rotate 1
}
END
</xsl:text>
</xsl:template>

</xsl:stylesheet>

