#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for setting inside and outside networks
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">stop</xsl:param>

<xsl:template match="/">
     <xsl:call-template name="networks"/>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="networks">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList">
        <xsl:choose>
                  <xsl:when test="@name='InsideNetworks'">
                      <xsl:call-template name="network-defn">
                          <xsl:with-param name="file">/config/wsxmlconf/inside.txt</xsl:with-param>
                      </xsl:call-template>
                  </xsl:when>
                  <xsl:when test="@name='OutsideNetworks'">
                      <xsl:call-template name="network-defn">
                          <xsl:with-param name="file">/config/wsxmlconf/outside.txt</xsl:with-param>
                      </xsl:call-template>
                  </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="network-defn">
   <xsl:param name="file"/>
    <xsl:text>&gt;</xsl:text>
    <xsl:value-of select="$file"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:for-each select="NetObject">
        <xsl:for-each select="Address">
            <xsl:text>/bin/echo </xsl:text>
            <xsl:value-of select="../@type"/>
            <xsl:text> &quot;</xsl:text>
            <xsl:value-of select="@value"/>
            <xsl:text>&quot;&gt;&gt;</xsl:text>
            <xsl:value-of select="$file"/>
            <xsl:text>&#10;</xsl:text>
        </xsl:for-each>
    </xsl:for-each>
     
</xsl:template>

</xsl:stylesheet>

