#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Script for starting load sharing
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">start</xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="start"/>
        </xsl:when>
        <xsl:when test="$param_0='stop'">
	    <xsl:call-template name="stop"/>
        </xsl:when>
        <xsl:when test="$param_0='restart' or $param_0='reload'">
	    <xsl:call-template name="stop"/>
	    <xsl:call-template name="start"/>
        </xsl:when>
	<xsl:otherwise>
	    echo "invalid option:<xsl:value-of select='$param_0'/>"
	    echo "valid options: start|stop|restart|reload"
	</xsl:otherwise>
     </xsl:choose>
     exit 0
</xsl:template>

<xsl:template name="stop">
<xsl:text>
    /usr/bin/killall -q rsmgr

    # There should not be any webshield proxies running at this point
    killall -q -KILL ws_smtp ws_http ws_pop3 ws_ftp ws_ls ws_icap
    killall -q -KILL ws_smtp ws_http ws_pop3 ws_ftp ws_ls ws_icap
    sleep 2
    if [ -d /proc/wsrmgr ]
    then
    	/sbin/rmmod wsrmgr &gt; /dev/null 2&gt;&amp;1
    fi
</xsl:text>
</xsl:template>

<xsl:template name="start">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='ls-settings']">
       <xsl:call-template name="install-ls"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="install-ls">
    <xsl:choose>
	<xsl:when test="Attr[@name='Enabled']/@value='1'">
            <xsl:call-template name="run-ls"/>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="run-ls">
<xsl:text>/sbin/insmod /opt/NETAwss/kernel/wsrmgr.o </xsl:text>
<xsl:text>sched=</xsl:text><xsl:value-of select="Attr[@name='Schedule']/@value"/><xsl:text> </xsl:text>
<xsl:text>lu_bias=</xsl:text><xsl:value-of select="Attr[@name='Bias']/@value"/><xsl:text> </xsl:text>
<xsl:text>cache=</xsl:text><xsl:value-of select="Attr[@name='Cache']/@value"/><xsl:text> </xsl:text>
<xsl:text>cachetimeout=</xsl:text><xsl:value-of select="Attr[@name='CacheTimeout']/@value"/><xsl:text> </xsl:text>
<xsl:text>datatimeout=</xsl:text><xsl:value-of select="Attr[@name='DataTimeout']/@value"/><xsl:text> </xsl:text>
<xsl:text>contimeout=</xsl:text><xsl:value-of select="Attr[@name='ConnectTimeout']/@value"/><xsl:text> </xsl:text>
<xsl:text>norequests=</xsl:text><xsl:value-of select="Attr[@name='Requests']/@value"/><xsl:text> </xsl:text>
<xsl:text>requeue=</xsl:text><xsl:value-of select="Attr[@name='Requeue']/@value"/><xsl:text> 
    test -d /proc/wsrmgr
    if [ $? != 0 ]
    then
	logger -t ws-appliance-rsmgr device driver has not created /proc/wsrmgr $RETSTR
        exit 1
    fi

RETSTR=`/usr/sbin/webshield rsmgr </xsl:text><xsl:value-of select="Attr[@name='Port']/@value"/>
<xsl:text> </xsl:text>
    <xsl:for-each select="NetObjectList[@name='Servers']/NetObject">
       <xsl:value-of select="Name/@value"/>
       <xsl:text> </xsl:text>
       <xsl:value-of select="Address/@value"/>
       <xsl:text> </xsl:text>
    </xsl:for-each>
<xsl:text>`
    RETCODE=$?
    if [ $RETCODE != 0 ]
    then
	logger -t ws-appliance-rsmgr  unable to start resrouce manager $RETSTR
	exit 1
    fi
</xsl:text>
</xsl:template>
</xsl:stylesheet>
