#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Script for installing transpareny driver
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">eth0</xsl:param>
<xsl:param name="config">/proc/wsnat/status</xsl:param>
<xsl:param name="param_0">stop</xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="start"/>
        </xsl:when>
     </xsl:choose>
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
	    <xsl:call-template name="stop"/>
        </xsl:when>
        <xsl:when test="$param_0='restart'">
	    <xsl:call-template name="stop"/>
	    <xsl:call-template name="start"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
	    <xsl:call-template name="stop"/>
	    <xsl:call-template name="start"/>
        </xsl:when>
     </xsl:choose>
     exit 0
</xsl:template>

<xsl:template name="stop">
    if [ -d /proc/wsnat ]
    then
    	/sbin/rmmod wsnat
    	/sbin/rmmod brnetif
    fi
    /usr/bin/killall -q wsnat_sched
</xsl:template>

<xsl:template name="start">
    <xsl:text>/bin/rm -rf /tmp/tx_schedule&#10;</xsl:text>
    <xsl:text>mkdir /tmp/tx_schedule&#10;</xsl:text>
    <xsl:text>/usr/bin/killall -q wsnat_sched&#10;</xsl:text>

    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='transparent']">
       <xsl:call-template name="install-transparencydriver"/>
    </xsl:for-each>
    <xsl:choose>
        <xsl:when test="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='transparent']/Attr[@name='Transparent']/@value='1'">
            <xsl:choose>
                <xsl:when test="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='transparent']/Attr[@name='TransparentBridge']/@value='1'">
                    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='transparent_bridge']">
	               <xsl:call-template name="transparent-bridge"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='transparent_router']">
	                <xsl:call-template name="transparent-router"/>
                   </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
	<xsl:otherwise>
	    <xsl:call-template name="proxy-mode"/>
	</xsl:otherwise>
    </xsl:choose>

    <xsl:call-template name="proxies"/>

    <xsl:call-template name="set_param">
        <xsl:with-param name="attribute">enabled</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
    </xsl:call-template>

    <xsl:text>/usr/sbin/webshield wsnat_sched&#10;</xsl:text>

</xsl:template>

<xsl:template name="install-transparencydriver">
<xsl:text>
if [ -f $NETAWSS/.profile.vars ]; then 
 . $NETAWSS/.profile.vars 
else 
 . /var/NAIENV/.profile.vars 
fi 
ADDRLIST=
ADDRS=`/sbin/ifconfig -a | grep "inet addr" |cut -f2 -d ":" | cut -f1 -d" " | grep -v 127.0.0.1`
for f in ${ADDRS}
do
if [ -z ${ADDRLIST} ]
then
     ADDRLIST=${f}
else
     ADDRLIST=${ADDRLIST}:${f}
fi
done
SPECULATIVE=0
SPECMULTICAST=0
RESET=0
/sbin/insmod /opt/NETAwss/kernel/brnetif.o &gt;/dev/null 2&gt;&amp;1
/sbin/insmod /opt/NETAwss/kernel/wsnat.o addresses=${ADDRLIST} 127.0.0.1 \
</xsl:text>
<xsl:text>inbndclt=</xsl:text><xsl:value-of select="Attr[@name='InboundConversations']/@value"/><xsl:text> </xsl:text>
<xsl:text>outbndpxy=</xsl:text><xsl:value-of select="Attr[@name='OutboundConversations']/@value"/><xsl:text> </xsl:text>
<xsl:text>&#10;</xsl:text>

<xsl:call-template name="set_param">
    <xsl:with-param name="attribute">redirecticmp3</xsl:with-param>
    <xsl:with-param name="value"><xsl:value-of select="Attr[@name='RedirectICMP3']/@value"/></xsl:with-param>
</xsl:call-template>

<xsl:call-template name="set_param">
    <xsl:with-param name="attribute">blockicmp5</xsl:with-param>
    <xsl:with-param name="value"><xsl:value-of select="Attr[@name='BlockICMP5']/@value"/></xsl:with-param>
</xsl:call-template>

<xsl:call-template name="set_param">
    <xsl:with-param name="attribute">fragment</xsl:with-param>
    <xsl:with-param name="value"><xsl:value-of select="Attr[@name='Fragment']/@value"/></xsl:with-param>
</xsl:call-template>
<!--
<xsl:call-template name="set_param">
    <xsl:with-param name="attribute"></xsl:with-param>
    <xsl:with-param name="value"><xsl:value-of select="Attr[@name='']/@value"/></xsl:with-param>
</xsl:call-template>

-->
</xsl:template>

<xsl:template name="transparent-router">
       <xsl:text>/bin/echo 1 &gt; /proc/sys/net/ipv4/ip_forward&#10;</xsl:text>
</xsl:template>

<xsl:template name="proxy-mode">
       <xsl:text>/bin/echo 0 &gt; /proc/sys/net/ipv4/ip_forward&#10;</xsl:text>
</xsl:template>


<xsl:template name="transparent-bridge">
      <xsl:text>/bin/echo 0 &gt; /proc/sys/net/ipv4/ip_forward&#10;</xsl:text>

    <xsl:call-template name="set_param">
    <xsl:with-param name="attribute">bridge-mac-tx</xsl:with-param>
    <xsl:with-param name="value"><xsl:value-of select="Attr[@name='MacAddress']/@value"/></xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="set_param">
        <xsl:with-param name="attribute">multicast</xsl:with-param>
        <xsl:with-param name="value"><xsl:value-of select="Attr[@name='Multicast']/@value"/></xsl:with-param>
    </xsl:call-template>

    <xsl:text>/bin/echo &quot;</xsl:text>
    <xsl:for-each select="List[@name='eth0_addresses']/Attr">
        <xsl:value-of select="@value"/><xsl:text> </xsl:text>
    </xsl:for-each>
    <xsl:text>&quot; &gt; /proc/wsnat/eth0_fdb&#10;</xsl:text>

    <xsl:text>/bin/echo &quot;</xsl:text>
    <xsl:for-each select="List[@name='eth1_addresses']/Attr">
        <xsl:value-of select="@value"/><xsl:text> </xsl:text>
    </xsl:for-each>
    <xsl:text>&quot; &gt; /proc/wsnat/eth1_fdb&#10;</xsl:text>

    <xsl:choose>
       <xsl:when test="Attr[@name='Speculative']/@value='1'">
       <xsl:text>SPECULATIVE=1&#10;</xsl:text>
       </xsl:when>
    </xsl:choose>

    <xsl:choose>
       <xsl:when test="Attr[@name='SpecMulticast']/@value='1'">
       <xsl:text>SPECMULTICAST=1&#10;</xsl:text>
       </xsl:when>
    </xsl:choose>

    <xsl:choose>
       <xsl:when test="Attr[@name='Reset']/@value='1'">
       <xsl:text>RESET=1&#10;</xsl:text>
       </xsl:when>
    </xsl:choose>
</xsl:template>


<xsl:template name="set_param">
    <xsl:param name="attribute"/>
    <xsl:param name="value"/>
    <xsl:text>/bin/echo &quot;</xsl:text><xsl:value-of select="$attribute"/><xsl:text>&quot; &quot;</xsl:text><xsl:value-of select="$value"/><xsl:text>&quot; &gt; /proc/wsnat/status&#10;</xsl:text>
</xsl:template>

<xsl:template name="proxies">
    
    <!-- Handle POP3 -->
    <xsl:call-template name="proxy">
        <xsl:with-param name="proxyname">pop3</xsl:with-param>
    </xsl:call-template>

    <!-- Handle SMTP -->
    <xsl:call-template name="proxy">
        <xsl:with-param name="proxyname">smtp</xsl:with-param>
    </xsl:call-template>

    <!-- Handle ICAP -->
    <xsl:call-template name="proxy">
        <xsl:with-param name="proxyname">icap</xsl:with-param>
    </xsl:call-template>

    <!-- Handle HTTP -->
    <xsl:call-template name="proxy">
        <xsl:with-param name="proxyname">http</xsl:with-param>
    </xsl:call-template>

    <!-- Handle FTP -->
    <xsl:call-template name="proxy">
        <xsl:with-param name="proxyname">ftp</xsl:with-param>
    </xsl:call-template>

</xsl:template>

<xsl:template name="proxy">
    <xsl:param name="proxyname"/>
    <xsl:text>PROXYNAME=</xsl:text><xsl:value-of select="$proxyname"/>
    <xsl:text>&#10;
    PROXYCONF=/config/wsxmlconf/${PROXYNAME}.xml
    test -f  $PROXYCONF
    if [ $? = 0 ]
    then
       xsltproc --stringparam proxy $PROXYNAME --stringparam speculative ${SPECULATIVE} --stringparam multicast ${SPECMULTICAST} --stringparam reset ${RESET} ${WSMGMT}/set_transparent_ports.xsl $PROXYCONF | /bin/bash
     fi
    </xsl:text>
</xsl:template>

</xsl:stylesheet>
