#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, signal
from tempfile import mktemp
from shutil import copyfile
from libwsa import _TR_, Trace

# args
#    vars : xml string
#    params : xml string

def sig_handler(signum, frame):
	sys.stderr.write("Got USR1 signal\n")
	Trace("Got USR1 signal\n")


libwsa.do_trace = True
signal.signal(signal.SIGUSR1, sig_handler)

def ScriptCallback(res):
	# write stdout and stderr on "our" stderr
	if res[0] != None:
		sys.stderr.write("stdout : " + res[0])
	if res[1] != None:
		sys.stderr.write("stderr : " + res[1])
	return True

def Run():
	try:
		####################################
		# parse the arguments
		####################################
		status = -1
		doit = False
		restart = False

		args, params = libwsa.Init()

		tmppath = "/opt/NETAwss/ui/wsadmin/scripts/test2.py"
		status = libwsa.RunCmd("%s >&2" % (tmppath), ScriptCallback)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		output = root.newChild(None, "output", None)
		output.setProp("name", "restart")
		output.setProp("value", str(status))
		output = root.newChild(None, "output", None)
		output.setProp("name", "TEXTDOMAIN")
		output.setProp("value", os.getenv("TEXTDOMAIN", ""))
		output = root.newChild(None, "output", None)
		output.setProp("name", "TEXTDOMAINDIR")
		output.setProp("value", os.getenv("TEXTDOMAINDIR", ""))
		output = root.newChild(None, "output", None)
		output.setProp("name", "LANGUAGE")
		output.setProp("value", os.getenv("LANGUAGE", ""))
		output.setProp("name", "WS_SESSION")
		output.setProp("value", os.getenv("WS_SESSION", ""))
		# we're done!
		print root.serialize()
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSPutConfig" id="1">
	<arg name="file" value="webshield" ref="/tmp/WebShield.xml"/>
	<arg name="restart" value="0"/>
</command>
	"""
	params = \
	"""
<params/>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
