#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
APPLYHF = "/opt/NETAwss/mgmt/ws_upgrade"

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML
	try:
		####################################
		# parse the arguments
		####################################
		args, params = libwsa.Init()

		a_ctxt = args.xpathNewContext()

		hf = a_ctxt.xpathEval("/command/arg[@name='file']/@ref")
		if len(hf) == 1:
			hf = hf[0].content
		else:
			raise RuntimeError, _TR_("WSHF_NHF", 'Invalid or missing "hf" argument')

		key = a_ctxt.xpathEval("/command/arg[@name='key']/@value")
		if len(key) == 1:
			key = key[0].content
		else:
			key = ''

		stdout = ""
		stderr = ""
		Trace("Launching '%s %s %s'" % (APPLYHF, hf, key))
		res = libwsa.RunCmd("%s '%s %s'" % (APPLYHF, hf, key), ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSHF_RFD", 'The installation of the hotfix failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		raise
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSApplyHotFix" id="1">
	<arg name="file" ref="/tmp/Sample1.tgz"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()

if __name__ == '__main__':
	Run()
