#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, re
from libwsa import _TR_
from libwsa import NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

Description="Change passwords"

def Run():
	global formatXML

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
	
		# get the new password
		try:
			password = ctxt.xpathEval("/command/arg[@name='user']/user[@name='webshield']/@password")
		except Exception:
			password = []
		# change the password only if rquired
		if len(password) == 1:
			password = password[0].content
			if len(password) == 0 or (re.compile('\s').search(password) != None):
				raise _TR_("WSS_BADPASS", "Invalid password")
                        os.environ["WS_NEW_PASSWORD"] = password
			status, msg = NewGetStatusOutput('/bin/echo "$WS_NEW_PASSWORD" | /usr/bin/passwd --stdin support')
			status, msg = NewGetStatusOutput('/bin/echo "!$WS_NEW_PASSWORD" | /usr/bin/passwd --stdin root')
			status, msg = NewGetStatusOutput('/bin/echo "$WS_NEW_PASSWORD" | /usr/sbin/saslpasswd2 -u webshield -pc webshield')
			status, msg = NewGetStatusOutput('/bin/echo "!$WS_NEW_PASSWORD" | /usr/sbin/saslpasswd2 -u webshield -pc root')
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd1 = \
	"""
<command name="SetUser" id="1">
    <arg name="user">
      <user name="webshield" password="a'*&quot;!ouch"/>
    </arg>
</command>
        """
        cmd2 = \
        """
<command name="SetUser" id="1">
    <arg name="user">
      <user name="webshield" password="webshieldchangeme"/>
    </arg>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd1, params ]
	Run()


if __name__ == '__main__':
	Run()
