#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

I_AV = 0
I_SPAM = 1

stdout = ""
stderr = ""

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		cmd = ''
		
		component =	ctxt.xpathEval("/command/arg[@name='component']/@value")
		if len(component) != 1:
				raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
		component = component[0].content

		if component == "av":
			type = I_AV
			cmd = "/opt/NETAwss/mgmt/remove_extra_dat"
		elif component == "spam":
			type = I_SPAM
			cmd = "/opt/NETAwss/mgmt/remove_extra_rules"
			xdats =	ctxt.xpathEval("/command/arg[@name='xdat']/@value")
			if len(xdats) != 1:
					raise _TR_("WSUN_BADXDAT", "Invalid or missing xdat argument")
			xdats = xdats[0].content
			cmd += " "+xdats
		else:
			raise _TR_("WSUN_BADCOMP", "Invalid or missing component argument")
		Trace("Launching '%s'" % cmd)
		res = libwsa.RunCmd(cmd, ScriptCallback)
		Trace("Done!")

		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSUXDT_FAILED", 'Unable to uninstall some extra files'), stdout+"\n"+stderr)
			sys.exit(-1)
	
		# let's go
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd_n_a_1 = \
	"""
<command name="WSDelXtraDat" id="1">
	<arg name="component" value="av"/>
</command>
	"""
	cmd_n_a_2 = \
	"""
<command name="WSDelXtraDat" id="1">
	<arg name="component" value="spam"/>
	<arg name="xdat" value="1 2 3"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	cmd = cmd_n_a_1
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()
	cmd = cmd_n_a_2
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
