#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace
from libwsa import NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

CMD = '/opt/NETAwss/mgmt/ws_ldap_identities'

# args
#    vars : xml string
#    params : xml string

def Run():
	####################################
	# parse the arguments
	####################################
	try:
		args, params = libwsa.Init()
	
		# TODO Generate the DirectoryGroups.xml file
		ldap = libxml2.newDoc("1.0")
		####################################
		# reply
		####################################
		# load the LDAP directory groups xml file
		status, dirs = NewGetStatusOutput(CMD)
		if status != 0:
			# NB: the return status returned by wait is shifted by 8 bits
			raise RuntimeError, _TR_("GETLDAP_FAIL", "LDAP query failed (%d)") % (status >> 8)
		try:
			doc = libxml2.parseDoc(dirs)
		except:
			raise RuntimeError, "Invalid xml string"
			
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "groups")
		content = doc.getRootElement()
		content.unlinkNode()
		elt.addChild(content)
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	
	except SystemExit:
		pass
	except Exception, details:
		libwsa.PrintError(details)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetDirectoryGroups" id="1">
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
