#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re, time, syslog, cStringIO
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
oob = None

IPURGE="exec su - cyrus -s /bin/sh -c '/usr/cyrus/bin/wsipurge"

def ScriptCallback(res):
    global stdout, stderr, oob
    if res[0] != None:
        for c in res[0]:
            if ord(c) > 127:
                stdout.write('{')
                stdout.write(str(ord(c)))
                stdout.write('}')
            else:
                stdout.write(c)
            #syslog.syslog(syslog.LOG_ERR, res[0])
    if res[1] != None:
        for c in res[1]:
            if ord(c) > 127:
                stderr.write('{')
                stderr.write(str(ord(c)))
                stderr.write('}')
            else:
                stderr.write(c)
            #syslog.syslog(syslog.LOG_ERR, res[1])
    return True

def Run():
    global stdout, stderr, formatXML, oob
    try:
        ####################################
        # parse the arguments
        ####################################
        args, params = libwsa.Init()

        try:
            oob = os.fdopen(3, 'w')
        except:
            oob = os.fdopen(2, 'w')

        a_ctxt = args.xpathNewContext()
        args = ""

        maxAge = a_ctxt.xpathEval("/command/arg[@name='max-age-in-days']/@value")
        if len(maxAge) != 1:
            raise RuntimeError, _TR_("WSQM_NAMA", 'No "max-age-in-days" argument')
        maxAge = int(maxAge[0].content)
        if maxAge <= 0:
            raise RuntimeError, _TR_("WSQM_INVMA", 'Invalid "max-age-in-days" argument')
        args += "-d %d" %maxAge

        deleteEMB = a_ctxt.xpathEval("/command/arg[@name='delete-empty-MB']/@value")
        if len(deleteEMB) != 1:
            raise RuntimeError, _TR_("WSQM_NAEM", 'No "delete-empty-MB" argument')
        deleteEMB = (int(deleteEMB[0].content) != 0)
        if deleteEMB:
            args += " -e "

        stdout = cStringIO.StringIO()
        stderr = cStringIO.StringIO()
        Trace("Launching '%s %s''" % (IPURGE, args))
        res = libwsa.RunCmd("%s %s'" % (IPURGE, args), ScriptCallback)
        if res != 0:
            libwsa.PrintErrorBase(_TR_("WSQM_CFD", 'The wsipurge command failed'), stdout.getvalue()+"\n"+stderr.getvalue())
            sys.exit(-1)
        ####################################
        # reply
        ####################################
        # just output the reply from the command
        print stdout.getvalue()
        sys.exit(0)
    except SystemExit:
        raise
    except:
        libwsa.PrintError(sys.exc_info()[1])
        sys.exit(-1)

def Test():
    """ Test function"""
    cmd = \
    """
<command name="WSQMaintenance" id="1">
    <arg name="max-age-in-days" value="3"/>
    <arg name="delete-empty-MB" value="1"/>
</command>
    """
    params = \
    """
<params>
</params>
    """
    sys.argv = [ sys.argv[0], cmd, params ]
    Run()

if __name__ == '__main__':
    Run()
