#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
TOP = "/usr/bin/top"

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0];
	if res[1] != None:
		stderr += res[1];
	return True

def Run():
	global stdout, stderr, formatXML
	try:
		####################################
		# parse the arguments
		####################################			
		args, params = libwsa.Init()

		
		stdout = ""
		stderr = ""
		Trace("Launching '%s %s'" % (TOP, args))
		res = libwsa.RunCmd("%s -b -n 1" % (TOP), ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSTP_CDF", 'The top command failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "top")
		elt.addChild(reply.newCDataBlock(stdout, len(stdout)))
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		raise
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSTop" id="1">
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()

if __name__ == '__main__':
	Run()
