#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import NewGetStatusOutput

BASE_DIR = "/opt/NETAwss/ui/www"
PLUGIN_DIR = os.path.join(BASE_DIR, "plugins")

# check the arguments
sname = os.path.basename(sys.argv[0])
if len(sys.argv) != 2:
	print >>sys.stderr, "%s: %s plugin-name" % (sname, sname)
	sys.exit(-1)
	
plugin_name = sys.argv[1]

# now load the global plugin files
path = os.path.join(BASE_DIR, "plugins.xml")
pi_xml = None
if os.path.isfile(path):
	try:
		pi_xml = libxml2.parseFile(path)
		if pi_xml.getRootElement().name == "Plugins":
			# remove any "install"
			ctxt = pi_xml.xpathNewContext()
			prev_nodes = ctxt.xpathEval("//Plugins/Plugin[@rpm='%s']" % plugin_name)
			for n in prev_nodes:
				n.unlinkNode()
			# save it
			pi_xml.saveFile(path)
				
			# fix any invalid access rights
			NewGetStatusOutput("chown root:apache '%s'" %path)
			NewGetStatusOutput("chmod a+r '%s'" %path)
			NewGetStatusOutput("chmod ug+w '%s'" %path)
	except:
		pass
