// Copyright (C) 2004 Networks Associates Technology Inc.
// All rights reserved.
//
// JavaScript support file for WebShield

// define some values for the OS
var osUnknown=-1;
var osWin=1;
var osUnix=2;

// define some values for the Browser type
var UnknownBrowser=-1;
var IEBrowser=1;
var NSBrowser=2;
var MZBrowser=3;
var OPBrowser=4;

// supported versions
var dwMinNSVersion=7.0;
var dwMaxNSVersion=8.0;
var dwMinMZVersion=1.3;
var dwMaxMZVersion=2.0;
var dwMinIEVersion=5.5;

var bEnableNS = true;
var bEnableMZ = true;
var bEnableOP = true;

// get some details about the browser
var _info = navigator.userAgent; 
var browserName = navigator.appName;
var browserType = UnknownBrowser;
var browserVer = 0.0;

var JreInstallionFile = "/jre/j2re-1_4_2_03-windows-i586-i.exe";

var JarCacheFileList = [
						"wsjava/webshield.jar",
						"wsjava/webshield_ui.jar",
						
						"exjava/TableLayout.jar",
						"exjava/foxtrot.jar",
						"exjava/jcalendar.jar",
						"exjava/jargs.jar",
						"exjava/jcommon.jar",
						"exjava/jfreechart.jar",
						"exjava/Piccolo.jar",
						"exjava/xstream.jar",
						"exjava/mail.jar",
						
						"esjava/eservicesapplet.jar",
						"esjava/policyui.jar",
						"esjava/interfaces.jar",
						"esjava/jbcl.jar",
						"esjava/naicommon.jar",
						"esjava/resources.jar",
						"esjava/xercesImpl.jar",
						"esjava/xmlParserAPIs.jar"
						]

function TestForIEorNSorMZ()
{
	if(browserName=="Microsoft Internet Explorer")
	{
		browserType = IEBrowser;
	}
	else if(browserName=="Netscape")
	{
		browserType = NSBrowser;
		if(_info.indexOf("Netscape") < 0)
		{
			if(_info.indexOf("Mozilla/5") >= 0)
			{
				browserName="Mozilla";
				browserType = MZBrowser;
			}
		}
	}
}

// call this to figure out the browser type
function getBrowserType()
{
	if(browserType==UnknownBrowser)
	{
		if(_info.indexOf("Opera") < 0)
		{
			TestForIEorNSorMZ();
		}
		else
		{
			browserName="Opera";
			browserType = OPBrowser;
		}
	}
	
	return browserType;
}

// Get the current version of the browser
function getBrowserVersion()
{
	getBrowserType();

	if(browserVer==0.0)
	{
		if(browserType==IEBrowser)
		{
			var nMSIE = _info.indexOf("MSIE");
			if(nMSIE > 0)
				browserVer = parseFloat(_info.substring(nMSIE+5));
		}
		else if(browserType==NSBrowser)
		{
			var nNS = _info.indexOf("Netscape");
			if(nNS >= 0)
			{
				var _ver = _info.substring(nNS+8);
				var nVER = _ver.indexOf("/");
				if(nVER >= 0)
					browserVer = parseFloat(_ver.substring(nVER+1));
			}
			else
			{
				browserVer = parseFloat(navigator.appVersion);
			}
		}
		else if(browserType==MZBrowser)
		{
			var nRV = _info.indexOf("rv:");
			if(nRV >= 0)
			{
				browserVer = parseFloat(_info.substring(nRV+3));
			}
		}
		else if(browserType==OPBrowser)
		{
			var nOPERA = _info.indexOf("Opera");
			if(nOPERA >= 0)
				browserVer = parseFloat(_info.substring(nOPERA+6));
		}
	
		if(isNaN(browserVer))
			browserVer=0.0;
	}
	
	return browserVer;
}

// this function sets the globals _win and _unix if either of those are the operating system we are running
function getOSType()
{
	// test to see whether we are Windows or Unix
	if((_info.indexOf("Win") > 0) && (_info.indexOf("Windows 3.1") < 0))
	{
		return osWin;
	}
	if((_info.indexOf("Sun") > 0) || (_info.indexOf("Linux") > 0))
	{
		return osUnix;
	}
	return osUnknown;
}

// this function detects the OS type, the browser type and the version, and decides if it meets spec.
// If it does then we get a return value of true, otherwise it returns false
function isBrowserUsable()
{
	var osType = getOSType();
	getBrowserType();
	getBrowserVersion();
	var fUsableBrowser = false;
	var lang = getBrowserLanguage();

	// test to see if we have a browser that is usable
	if(browserType==IEBrowser)
	{
		if(osType==osWin || osType==osUnix)
		{
			if(browserVer>=dwMinIEVersion)
				fUsableBrowser=true;
		}
	}
	else if(browserType==NSBrowser)
	{
		if(osType==osWin)
		{
			if(browserVer>=dwMinNSVersion && browserVer<dwMaxNSVersion)
				fUsableBrowser=bEnableNS;
		}
		
		if(osType==osUnix)
		{
			if(browserVer>=dwMinNSVersion && browserVer<dwMaxNSVersion)
				fUsableBrowser=bEnableNS;
		}
	}
	else if(browserType==MZBrowser)
	{
			if(browserVer>=dwMinMZVersion && browserVer<dwMaxMZVersion)
				fUsableBrowser=bEnableMZ;
	}
	else if(browserType==OPBrowser)
	{
		fUsableBrowser = bEnableOP;
	}
	
	return fUsableBrowser;
}

// Detect the browser language
function getBrowserLanguage()
{
	var browserType = getBrowserType();

	var language = "en";

	if(browserType==IEBrowser)
	{
		language = navigator.browserLanguage;
	}
	else if(browserType==NSBrowser)
	{
		language = navigator.language;
	}
	
	switch(language)
	{
	case "fr":
		return "fr_FR";
	case "de":
		return "de_DE";
	case "ja":
		return "ja_JP";
	case "es":
		return "es_ES";
	case "ko":
		return "ko_KR";
	case "zh-cn":
		return "zh_CN";
	case "zh-tw":
		return "zh_TW";
	}
	
	return "en_US";
}

function useObjectTag()
{
	if (getBrowserType() == IEBrowser)
		return true;
	return false;
}

function useEmbedTag()
{
	if (getBrowserType() == NSBrowser || getBrowserType() == MZBrowser)
		return true;
	return false;
}

function getArchiveList()
{
	var list = "";
	for(i=0;i < JarCacheFileList.length;i++)
	{
		if(i == 0)
			list += JarCacheFileList[i];
		else
			list += "," + JarCacheFileList[i];
	}
	return list;
}

function getArchiveExList()
{
	var list = "";
	for(i=0;i < JarCacheFileList.length;i++)
	{
		if(i == 0)
			list += JarCacheFileList[i]+";preload";
		else
			list += "," + JarCacheFileList[i]+";preload";
	}
	return list;
}

function getVersionList()
{
	var list = "";
	for(i=0;i < JarCacheFileList.length;i++)
	{
		if(i == 0)
			list += "3.0.0.0";
		else
			list += "," + "3.0.0.0";
	}
	return list;
}

function loadMainApplet()
{
	if (useObjectTag())
	{
		document.writeln('<OBJECT classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" WIDTH ="100%" HEIGHT="100%" CODEBASE="'+JreInstallionFile+'">');
		paramMainApplet("code",             "com.nai.webshield.WSMainApplet");
		paramMainApplet("codebase",         "/");
		paramMainApplet("type",             "application/x-java-applet");
		paramMainApplet("cache_option",     "Plugin");
//		paramMainApplet("cache_archive_ex",  getArchiveExList());
		paramMainApplet("cache_archive",     getArchiveList());
		paramMainApplet("cache_version",     getVersionList());
		paramMainApplet("scriptable",       "true");
		paramMainApplet("mayscript",        "true");
	}
	else
	{
		if (useEmbedTag()) 
		{
			document.writeln('<EMBED type="application/x-java-applet"  ' +
							 'width ="100%" height="100%" ' +
							 'code="com.nai.webshield.WSMainApplet" ' +
							 'codebase="/" ' +
							 'cache_option="Plugin" ' +
//							 'cache_archive_ex="'+getArchiveExList+'" ' +
							 'cache_archive="'+getArchiveList()+'" ' +
							 'cache_version="'+getVersionList()+'" ' +
							 'pluginspage="/plugin.html" ' +
							 'scriptable="true" ' +
							 'mayscript="true" '
							 );
		}
	}
}

function paramMainApplet(name,value)
{
	if (useObjectTag())
	{
		document.writeln('<PARAM NAME="'+name+'" VALUE="'+value+'"/>');
	}
	else
	{
		if (useEmbedTag()) 
		{ 
			 document.writeln(name+'="'+value+'" ');
		}
	}
}

function endMainApplet()
{
	if (useObjectTag())
	{
		document.writeln('</OBJECT>');
	}
	else
	{
		if (useEmbedTag()) 
			document.writeln ('><NOEMBED>' + szJavaPluginMissing + '</NOEMBED></EMBED>');
	}
}

function loadJavaCheckApplet()
{
	if (useObjectTag())
	{
		document.writeln('<OBJECT classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" WIDTH ="1" HEIGHT="1" CODEBASE="'+JreInstallionFile+'">');
		paramMainApplet("code",             "com.nai.webshield.WSJavaCheck");
		paramMainApplet("codebase",         "/");
		paramMainApplet("type",             "application/x-java-applet");
		paramMainApplet("cache_option",     "Plugin");
		paramMainApplet("cache_archive",    "wsjava/javachecks.jar");
		paramMainApplet("cache_version",    "3.0.0.0");
		paramMainApplet("scriptable",       "true");
		paramMainApplet("mayscript",        "true");

		paramMainApplet("java_checks",      "JRE");
		paramMainApplet("jre_ver_req",      "142_00+");
		paramMainApplet("redirection",      "webshield.html");
		document.writeln('</OBJECT>');
	}
	else
	{
		if (useEmbedTag()) 
		{
			document.writeln('<EMBED type="application/x-java-applet"  ' +
							 'width ="1" height="1" ' +
							 'code="com.nai.webshield.WSJavaCheck" ' +
							 'codebase="/" ' +
							 'cache_option="Plugin" ' +
							 'cache_archive="wsjava/javachecks.jar" ' +
							 'cache_version="3.0.0.0" ' +
							 'pluginspage="/plugin.html" ' +
							 'scriptable="true" ' +
							 'mayscript="true" '+

							 'java_checks="JRE" '+
							 'jre_ver_req="142_00+" '+
							 'redirection="webshield.html" '
							 );
			document.writeln ('><NOEMBED>' + szJavaPluginMissing + '</NOEMBED></EMBED>');
		}
	}
}
