<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating the NIC hardware settings for E1000 Adapter
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:text>Speed=</xsl:text>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList[@type='NIC']">
	<xsl:call-template name="speed_settings"/>
        <xsl:choose>
	    <xsl:when test="@name='eth0'">
               <xsl:text>,</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
    <xsl:text> Duplex=</xsl:text>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList[@type='NIC']">
	<xsl:call-template name="duplex_settings"/>
        <xsl:choose>
	    <xsl:when test="@name='eth0'">
               <xsl:text>,</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="speed_settings">
    <xsl:choose>
	<xsl:when test="AutoNegotiate/@value='on'">
            <xsl:text>0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
        	<xsl:when test="Speed/@value='10'">
                    <xsl:text>10</xsl:text>
                </xsl:when>
        	<xsl:when test="Speed/@value='100'">
                    <xsl:text>100</xsl:text>
                </xsl:when>
        	<xsl:when test="Speed/@value='1000'">
                   <xsl:text>1000</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="duplex_settings">
    <xsl:choose>
	<xsl:when test="AutoNegotiate/@value='on'">
            <xsl:text>0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
	        <xsl:when test="Duplex/@value='full'">
                    <xsl:text>2</xsl:text>
                </xsl:when>
	        <xsl:when test="Duplex/@value='half'">
                    <xsl:text>1</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>

