<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating appliance configuration
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="proxy">pop3</xsl:param>
<xsl:param name="reset">0</xsl:param>
<xsl:param name="multicast">0</xsl:param>
<xsl:param name="speculative">0</xsl:param>

<xsl:template match="/">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='network']">
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
	        <xsl:call-template name="proxysettings">
                   <xsl:with-param name="proxy"><xsl:value-of select="$proxy"/></xsl:with-param>
                   <xsl:with-param name="speculative"><xsl:value-of select="$speculative"/></xsl:with-param>
                   <xsl:with-param name="reset"><xsl:value-of select="$reset"/></xsl:with-param>
                   <xsl:with-param name="multicast"><xsl:value-of select="$multicast"/></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
         </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="proxysettings">
    <xsl:param name="proxy"/>
    <xsl:param name="speculative"/>
    <xsl:param name="reset"/>
    <xsl:param name="multicast"/>
set_rule()
{
    TRANSPOPT=
    if [ $1  == Y ]
    then
         <xsl:text>echo &gt;/dev/null&#10;</xsl:text>
         <xsl:choose>
           <xsl:when test="$speculative='1'">
               <xsl:text>TRANSPOPT=${TRANSPOPT}/speculative&#10;</xsl:text>
           </xsl:when>
         </xsl:choose>

         <xsl:choose>
           <xsl:when test="$multicast='1'">
               <xsl:text>TRANSPOPT=${TRANSPOPT}/multicast&#10;</xsl:text>
           </xsl:when>
         </xsl:choose>

         <xsl:choose>
           <xsl:when test="$reset='1'">
               <xsl:text>TRANSPOPT=${TRANSPOPT}/reset_unknown&#10;</xsl:text>
           </xsl:when>
         </xsl:choose>
            

    fi
    echo rule ${2}/protocol${PROXY}${TRANSPOPT} > /proc/wsnat/status
}
    <xsl:text>PROXY=</xsl:text>
    <xsl:value-of select="$proxy"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>LISTENPORTS=&#10;</xsl:text>
    <xsl:for-each select="List[@name='BindPorts']/Attr">
        <xsl:text>LISTENPORTS=&quot;${LISTENPORTS} </xsl:text><xsl:value-of select="@value"/><xsl:text>&quot;&#10;</xsl:text>
    </xsl:for-each>

    <xsl:text>INTERPORTS=&#10;</xsl:text>
    <xsl:choose>
        <xsl:when test="Attr[@name='Transparent']/@value='1'">
            <xsl:for-each select="List[@name='InterceptPorts']/Attr">
                <xsl:text>INTERPORTS=&quot;${INTERPORTS} </xsl:text><xsl:value-of select="@value"/><xsl:text>&quot;</xsl:text>
                <xsl:text>&#10;</xsl:text>
            </xsl:for-each>

             <xsl:for-each select="NetObjectList[@name='TransparencyExceptions']/NetObject[@type='TRANSPARENCYEXCEPTION']">
                 <xsl:call-template name="transparency-exception">
                      <xsl:with-param name="proxy"><xsl:value-of select="$proxy"/></xsl:with-param>
                 </xsl:call-template>
             </xsl:for-each>
        </xsl:when>
    </xsl:choose>

    <xsl:text>
    ACCEPT=&#10;
    MASTERPORT=
    for PORT in $LISTENPORTS
    do
        FOUND=N
        for INTPORT in $INTERPORTS
        do
            if [ -z "${MASTERPORT}" ]
            then
                MASTERPORT=$PORT
            fi
            if [ $PORT -eq $INTPORT  ]
            then
                 FOUND=Y
            fi
        done
        if [ $FOUND = N ]
        then
		ACCEPT="${ACCEPT} $PORT"
        fi
    done
   
    for PORT in $ACCEPT
    do
         set_rule N ${PORT}:${PORT}/proxy
    done

    for PORT in $INTERPORTS
    do
         set_rule Y ${PORT}:${MASTERPORT}
    done
  
</xsl:text>
</xsl:template>

<xsl:template name="transparency-exception">
    <xsl:param name="proxy"/>
    <xsl:text>cat &lt;&lt;END &gt;&gt;/tmp/tx_schedule/</xsl:text>
    <xsl:value-of select="$proxy"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:value-of select="Port/@value"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="StartHour/@value"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="StartMinute/@value"/>
    <xsl:text> src </xsl:text>
    <xsl:value-of select="Source/@value"/>
    <xsl:text> dest </xsl:text>
    <xsl:value-of select="Destination/@value"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>END&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>

