#!/usr/bin/wsrunxslt /config/wsxmlconf/smtp.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet starting a proxy
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0"></xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start' or $param_0='restart' or $param_0='reload'">
	    <xsl:call-template name="enableimap"/>
        </xsl:when>
     </xsl:choose>
     exit 0
</xsl:template>

<xsl:template name="enableimap">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='network']">
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
                <xsl:text>/sbin/chkconfig --level 3 cyrus on&#10;</xsl:text>
	       <xsl:call-template name="configimap"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>/sbin/chkconfig --level 3 cyrus off&#10;</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="configimap">
DUPLICATE_SUPPRESSION=no
<xsl:choose>
    <xsl:when test="Attr[@name='QuarantineDuplicateSuppression']/@value='1'">
        DUPLICATE_SUPPRESSION=yes
    </xsl:when>
</xsl:choose>
cat &lt;&lt;-END &gt;/etc/imapd.conf
configdirectory: /quarantine/var/imap
partition-default: /quarantine/imap
admins: cyrus webshield@webshield root@webshield
sasl_pwcheck_method: auxprop
sasl_mech_list: PLAIN
autocreatequota: -1
createonpost: 1
munge8bit: no
duplicatesuppression: ${DUPLICATE_SUPPRESSION}
END
</xsl:template>

</xsl:stylesheet>

