#!/usr/bin/wsrunxslt /config/wsxmlconf/network.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for ldap configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:for-each select="//GlobalSettings[@name='network']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='ldap-settings']">
	<xsl:call-template name="ldapsettings"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="ldapsettings">
   <xsl:variable name="enabled" select="Attr[@name='Enabled']/@value='1'"/>
   <xsl:choose>
        <xsl:when test="$enabled='true'">
	     <xsl:text>/sbin/chkconfig --level 3 ldap on&#10;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
	     <xsl:text>/sbin/chkconfig --level 3 ldap off&#10;</xsl:text>
	     <xsl:text>service ldap stop&#10;</xsl:text>
             <xsl:text>exit 0&#10;</xsl:text>
        </xsl:otherwise>
   </xsl:choose>   

</xsl:template>
</xsl:stylesheet>

