#!/usr/bin/wsrunxslt /config/wsxmlconf/system.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for spam daemon configuration
	Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
        </xsl:when>
        <xsl:when test="$param_0='restart'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
	    <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="set_config">
    <xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='spamdaemon']">
	<xsl:call-template name="spamdaemon"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="spamdaemon">
   <xsl:variable name="enabled" select="Attr[@name='Enabled']/@value='1'"/>
   <xsl:choose>
        <xsl:when test="$enabled='true'">
	     <xsl:text>restart=false&#10;</xsl:text>
	     <xsl:text>/sbin/chkconfig --level 3 spamassassin_jail ||
		restart=true&#10;</xsl:text>
	     <xsl:text>/sbin/chkconfig --level 3 spamassassin_jail on&#10;</xsl:text>
	     <xsl:call-template name="setoptions"/>
	     <xsl:text>$restart &amp;&amp; [[ -f $WS_RESTART_LIST ]]  &amp;&amp;
		echo spamassassin_jail &gt;&gt; $WS_RESTART_LIST&#10;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
	     <xsl:text>if /sbin/chkconfig --level 3 spamassassin_jail; then
		/etc/init.d/spamassassin_jail stop
		/sbin/chkconfig --level 3 spamassassin_jail off
		fi&#10;</xsl:text>
        </xsl:otherwise>
   </xsl:choose>   
</xsl:template>

<xsl:template name="setoptions">
    <xsl:text>opts=&quot;OPTIONS=\&quot;</xsl:text>
    <xsl:value-of select="Attr[@name='Parameters']/@value"/>
    <xsl:text>\&quot;&quot;&#10;</xsl:text>
    <xsl:text>if [[ $(&lt; /etc/sysconfig/spamassassin) != "$opts" ]]; then
	echo "$opts" &gt; /etc/sysconfig/spamassassin
	restart=true
	fi&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>

