#!/usr/bin/wsrunxslt /config/wsxmlconf/system.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
    Style sheet for spam daemon configuration
    Copyright (C) 2004 Networks Associates Technology Inc.  All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start'">
        <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
    <xsl:choose>
        <xsl:when test="$param_0='stop'">
        </xsl:when>
        <xsl:when test="$param_0='restart'">
        <xsl:call-template name="set_config"/>
        </xsl:when>
        <xsl:when test="$param_0='reload'">
        <xsl:call-template name="set_config"/>
        </xsl:when>
     </xsl:choose>
     <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

<xsl:template name="set_config">
    <xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='talkback']">
    <xsl:call-template name="talkback"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="talkback">
  
   <xsl:variable name="enabled" select="Attr[@name='Enabled']/@value='1'"/>
   <xsl:choose>
        <xsl:when test="$enabled='true'">
        <xsl:text>echo &quot;0,5,10,15,20,25,30,35,40,45,50,55 * * * * root /usr/sbin/webshield ws_talkscript&quot; &gt; /etc/cron.d/webshield_talkback&#10;</xsl:text>
         <xsl:text>cat &lt;&lt;END &gt; /config/wsxmlconf/talkback&#10;</xsl:text>
         <xsl:text>TALKBACK_ENABLED=Y&#10;</xsl:text>
         <xsl:text>TALKBACK_ADDRESS=&quot;</xsl:text><xsl:value-of select="Attr[@name='EmailAddress']/@value"/><xsl:text>&quot;&#10;</xsl:text>
         <xsl:text>TALKBACK_SUBJECT=&quot;</xsl:text><xsl:value-of select="Attr[@name='Subject']/@value"/><xsl:text>&quot;&#10;</xsl:text>
         <xsl:text>TALKBACK_SOURCE=</xsl:text><xsl:value-of select="Attr[@name='Source']/@value"/><xsl:text>&#10;</xsl:text>
         <xsl:text>TALKBACK_RATE=</xsl:text><xsl:value-of select="Attr[@name='TalkbackRate']/@value"/><xsl:text>&#10;</xsl:text>
         <xsl:text>END&#10;</xsl:text>
            <xsl:variable name="rate" select="Attr[@name='TalkbackRate']/@value"/>
             <xsl:choose>
                  <xsl:when test="$rate='hourly'">

         		<xsl:text>echo &quot;0 * * * * root /usr/sbin/webshield ws_talkmail&quot; &gt;&gt; /etc/cron.d/webshield_talkback&#10;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$rate='daily'">
         		<xsl:text>echo &quot;50 23  * * * root /usr/sbin/webshield ws_talkmail&quot; &gt;&gt; /etc/cron.d/webshield_talkback&#10;</xsl:text>
                  </xsl:when>
             </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>echo TALKBACK_ENABLED=N&gt;/config/wsxmlconf/talkback&#10;</xsl:text>
        <xsl:text>/bin/rm -f /etc/cron.d/webshield_talkback&#10;</xsl:text>
        </xsl:otherwise>
   </xsl:choose>   
   <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>

