#!/usr/bin/python
# Copyright (C) 2005 McAfee Inc. All rights reserved.
import os, sys, libxml2

VERSION = open("/.version").read()
if VERSION.startswith("0010"):
    # VERSION 3
    ADMIN="webshield"
else:
    # VERSION 4
    ADMIN="scmadmin"

FILES = ["/config/wsxmlconf/wsadmin/users.xml", 
         "/opt/NETAwss/proto/xmlconfdir/wsadmin/users.xml", 
         "/opt/NETAwss/ui/wsadmin/config/users.xml"]


def cleanFile(path):
    doc = libxml2.parseFile(path)
    ctxt = doc.xpathNewContext()
    nodes = ctxt.xpathEval("/users/user[@name != '%s']" % ADMIN)
    for n in nodes:
        n.unlinkNode()
        n.freeNode()
    doc.saveFile(path)

for f in FILES:
    cleanFile(f)
