#!/bin/sh
# Copyright (C) 2004 Networks Associates Technology Inc. All rights reserved.

skiplines=# set by make
checksize=# set by make
checkcksum=# set by make
demo=''# set by make

installdir=/opt/WebShieldClient
[ -n "$demo" ] && installdir=/opt/WebShieldDemo

Extract()
{
    tail "+$skiplines" "$0"
}

CheckMe()
{
    if type cksum >/dev/null 2>&1; then
	c=`Extract | cksum`
	c=`echo $c`
	[ "$checkcksum" = "$c" ] && return 0
    elif [ $checksize -eq `Extract | wc -c` ]; then
	return 0
    fi
    echo "Error: $0 appears to be corrupted" >&2
    return 1
}

GetDir()
{
    echo "Select a directory in which to install the WebShield$demo client."
    echo "To accept the name given in [] just enter an empty line."
    echo "Otherwise type the name you want and confirm your selection"
    while :; do
	ans=$installdir
	while :; do
	    printf '%s' "Install directory? [$ans] "
	    read ans
	    [ "T$ans" = "T" ] && break
	    installdir=$ans
	    if c=`ls -ld "$ans" 2>/dev/null`; then
		echo "Warning: $ans already exists:"
		echo "$c"
	    fi
	done
	while [ `ls -A "$installdir" 2>/dev/null | wc -c` -gt 0 ]; do
	    if [ -d "$installdir" ]; then
		echo "$installdir is not an empty directory"
	    elif ls -d "$installdir" >/dev/null 2>&1; then
		echo "$installdir exists and is not a directory"
	    else
		break 2
	    fi
	    printf "Remove $installdir? (yes or no) "
	    read yn
	    case $yn in
		[yY]*)
		    rm -rf "$installdir" &&
			[ `ls -A "$installdir" 2>/dev/null | wc -c` -le 0 ] &&
			echo "$installdir removed" &&
			break
		    continue
		    ;;
		[nN]*)
		    continue 2
		    ;;
		*)
		    continue
		    ;;
	    esac
	done
	[ -d "$installdir" ] || mkdir -p -m 755 "$installdir"
	[ -d "$installdir" -a -w "$installdir" ] && break
	echo "Failed to create writable $installdir" >&2
    done
    return 0
}

CheckMe && GetDir || exit

echo "Extracting installation files..."
if Extract | ( cd "$installdir" && exec tar -xf - ); then :
else
    echo "Error: failed to extract installation files" >&2
    exit 1
fi
cd "$installdir" || exit
installdir=`/bin/pwd`
chmod a=r *
chmod a=rx setup ws_launch_browser
[ -n "$demo" ] && : >demo_version
exec "$installdir/setup"

exit 1
##tarball_follows##
