#!/usr/bin/wsrunxslt /config/wsxmlconf/system.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet starting a proxy
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0"></xsl:param>

<xsl:template match="/">

    <xsl:for-each select="//GlobalSettings[@name='system']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='disk-settings']/NetObjectList[@name='disk']">
       <xsl:call-template name="setup-disks"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="setup-disks">
    <xsl:for-each select="NetObject[@type='DISK']">
       <xsl:call-template name="setup-disk"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="setup-disk">
    <xsl:choose>
        <xsl:when test="Enabled/@value='1'">
            <xsl:text>echo </xsl:text>
            <xsl:value-of select="FileSystem/@value"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="WarningDiskUsed/@value"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="WarningFilesUsed/@value"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="CriticalDiskUsed/@value"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="CriticalFilesUsed/@value"/>
            <xsl:text>&#10;</xsl:text>
        </xsl:when>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>

