<?xml version="1.0" encoding="UTF-8"?>
<!--
	Copyright (C) 2003-2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xinclude="http://www.w3.org/1999/XML/xinclude"
>
<xsl:output method="xml" encoding="UTF-8" standalone="yes" indent="yes"/>
<xsl:param name="BadwordsTemplate"/>
<xsl:variable name="AddRuleGroups" select="document( $BadwordsTemplate,. )//RuleSet/RuleGroup"/>


<xsl:template match="/">

	<xsl:if test="count($AddRuleGroups)=0">
		<xsl:message terminate="yes">No rule groups found for <xsl:value-of select="$BadwordsTemplate"/></xsl:message>
	</xsl:if>

	<xsl:apply-templates select="RuleSet"/>

</xsl:template>

<xsl:template match="RuleSet">
	<xsl:variable name="Top" select="."/>
	<xsl:copy>
		<xsl:apply-templates select="@*|text()|*" mode="copy"/>

		<xsl:for-each select="$AddRuleGroups">
			<xsl:if test="not($Top/RuleGroup[@name=current()/@name])">
				<xsl:copy-of select="."/>
			</xsl:if>
		</xsl:for-each>
	</xsl:copy>

</xsl:template>

<xsl:template match="*" mode="copy">
	<xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="text()|@*" mode="copy">
	<xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>
