<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for named.conf
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:for-each select="//GlobalSettings[@name='network']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']">
	<xsl:call-template name="dnssettings"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="dnssettings">
   <xsl:variable name="forward_dns" select="Attr[@name='ForwardModeDNS']/@value='1'"/>
   <xsl:variable name="extended_dns" select="Attr[@name='Extended DNS']/@value='1'"/>
   <xsl:variable name="querysource" select="Attr[@name='BindQueryPort']/@value"/>

// generated by Webshield Appliance

options {
<xsl:choose>
    <xsl:when test="$querysource!='0'">
	    <xsl:text>query-source address * port </xsl:text>
	    <xsl:value-of select="$querysource"/>
	    <xsl:text>;&#10;</xsl:text>
    </xsl:when>
</xsl:choose>
<xsl:choose>
    <xsl:when test="$forward_dns='true'">
    <xsl:text>forward only;&#10;</xsl:text>
    </xsl:when>
</xsl:choose>
<xsl:text>forwarders {</xsl:text>
<xsl:for-each select="NetObjectList[@name='NameServers']/NetObject">
   <xsl:value-of select="Address/@value"/>
<xsl:text>;</xsl:text>
    </xsl:for-each>
<xsl:text>};</xsl:text>
directory "/var/named";
        listen-on { 127.0.0.1; };
	/*
	 * If there is a firewall between you and nameservers you want
	 * to talk to, you might need to uncomment the query-source
	 * directive below.  Previous versions of BIND always asked
	 * questions using port 53, but BIND 8.1 uses an unprivileged
	 * port by default.
	 */
	// query-source address * port 53;
};

// 
// a caching only nameserver config
// 
zone "." IN {
	type hint;
	file "named.ca";
};

zone "localhost" IN {
	type master;
	file "localhost.zone";
	allow-update { none; };
};

zone "0.0.127.in-addr.arpa" IN {
	type master;
	file "named.local";
	allow-update { none; };
};
<xsl:for-each select="NetObjectList[@name='NameServers']/NetObject">
   <xsl:text>server </xsl:text>
   <xsl:value-of select="Address/@value"/>
   <xsl:text>  { </xsl:text>
   <xsl:text> edns </xsl:text>
      <xsl:choose>
          <xsl:when test="$extended_dns='true'">
              <xsl:text>yes;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
              <xsl:text>no;</xsl:text>
          </xsl:otherwise>
      </xsl:choose>
   <xsl:text>};</xsl:text>

</xsl:for-each>

// end generated by Webshield Appliance


</xsl:template>
</xsl:stylesheet>

