<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for generating appliance configuration
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="proxy">ftp</xsl:param>

<xsl:template match="/">
    <xsl:text>--proxy </xsl:text>
    <xsl:value-of select="$proxy"/>
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='network']">
<xsl:value-of select="Attr[@name='Priority']/@value"/>
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
	        <xsl:call-template name="proxyhealth">
                    <xsl:with-param name="proxy"><xsl:value-of select="$proxy"/></xsl:with-param>
	        </xsl:call-template>
             
            </xsl:when>
            <xsl:otherwise>
               <xsl:text> --port off </xsl:text>
            </xsl:otherwise>
         </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="proxyhealth">
    <xsl:param name="proxy"/>
        <xsl:choose>
            <xsl:when test="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='process']/Attr[@name='MonitorHealth']/@value='1'">
	        <xsl:call-template name="proxystate">
                    <xsl:with-param name="proxy"><xsl:value-of select="$proxy"/></xsl:with-param>
	        </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text> --port off </xsl:text>
            </xsl:otherwise>
         </xsl:choose>
</xsl:template>

<xsl:template name="proxystate">
    <xsl:param name="proxy"/>
    <xsl:for-each select="List[@name='BindPorts']/Attr">
       <xsl:text> --port </xsl:text>
        <xsl:value-of select="@value"/>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>

