<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet starting a proxy
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="name"></xsl:param>
<xsl:param name="executable"></xsl:param>
<xsl:param name="protocol"></xsl:param>
<xsl:param name="parameters"></xsl:param>

<xsl:template match="/">
    <xsl:for-each select="/PolicySet/GlobalSettings[@name='base']/Policy[@ID='base']/PolicyStatement/Settings[@name='network']">
        <xsl:choose>
            <xsl:when test="Attr[@name='Enabled']/@value='1'">
	        <xsl:call-template name="runproxy">
                   <xsl:with-param name="name"><xsl:value-of select="$name"/></xsl:with-param>
                   <xsl:with-param name="executable"><xsl:value-of select="$executable"/></xsl:with-param>
                   <xsl:with-param name="protocol"><xsl:value-of select="$protocol"/></xsl:with-param>
                   <xsl:with-param name="parameters"><xsl:value-of select="$parameters"/></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>exit 0&#10;</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
    </xsl:for-each>
    <xsl:text>exit 1&#10;</xsl:text>
</xsl:template>

<xsl:template name="runproxy">
    <xsl:param name="name"/>
    <xsl:param name="executable"/>
    <xsl:param name="protocol"/>
    <xsl:param name="parameters"/>
    <xsl:value-of select="$executable"/>
    <xsl:text> </xsl:text><xsl:value-of select="$name"/>
    <xsl:text> </xsl:text><xsl:value-of select="$protocol"/>
    <xsl:text> </xsl:text><xsl:value-of select="$parameters"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>exit $?&#10;</xsl:text>
</xsl:template>
</xsl:stylesheet>

