#!/usr/bin/wsrunxslt /config/wsxmlconf/machine.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for network interface settings
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:param name="param_0">stop</xsl:param>

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$param_0='start' or $param_0='restart' or $param_0='reload'">
	    <xsl:call-template name="configif"/>
        </xsl:when>
     </xsl:choose>
     exit 0
</xsl:template>

<xsl:template name="configif">
    <xsl:variable name="host_name" select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/Attr[@name='IPHostname']/@value"/>
    <xsl:variable name="domain_name" select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/Attr[@name='IPDomainName']/@value"/>

shopt -s extglob nullglob
cfgbase=/etc/sysconfig/network-scripts/ifcfg-
oklist=lo
restart_list=''

    <xsl:for-each select="/PolicySet/GlobalSettings[@name='machine']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='network-settings']/NetObjectList[@type='NIC']">

if_name=<xsl:value-of select='@name'/>
alias_no=0
if_suffix=''
	<xsl:for-each select="NetObject[@type='NIC']">
	    <xsl:choose>
		<xsl:when test="State/@value='on'">
cfg=${cfgbase}${if_name}${if_suffix}
oklist="$oklist|${if_name}${if_suffix}"
newcfg="DEVICE=${if_name}${if_suffix}
BOOTPROTO=static
ONBOOT=yes
IPADDR=<xsl:value-of select="Address/@value"/>
NETMASK=<xsl:value-of select="NetMask/@value"/>
MTU=<xsl:value-of select='../MTU/@value'/>"
if [[ ! -f "$cfg" || "$newcfg" != "$(&lt;$cfg)" ]]; then
    echo "$newcfg" &gt; "$cfg"
    restart_list=$WS_RESTART_LIST
fi

if_suffix=:$(( ++alias_no ))
		</xsl:when>
	    </xsl:choose>
	</xsl:for-each>
    </xsl:for-each>
for f in $cfgbase!($oklist); do
    ifdown ${f#"$cfgbase"}
    rm -f "$f"
    restart_list=$WS_RESTART_LIST
done
[[ -f $restart_list ]] &amp;&amp; echo network &gt;&gt; $restart_list
</xsl:template>
</xsl:stylesheet>

