#!/usr/bin/wsrunxslt /config/wsxmlconf/network.xml
<?xml version="1.0" encoding="UTF-8"?>
<!--
	Style sheet for ntpd configuration
	Copyright (C) 2004 Networks Associates Technology Inc.
	All rights reserved.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/">
    <xsl:for-each select="//GlobalSettings[@name='network']/Policy[@name='system_variables']/PolicyStatement/Settings[@name='ntp-settings']">
	<xsl:call-template name="ntpsettings"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="ntpsettings">
   <xsl:variable name="enabled" select="Attr[@name='Enabled']/@value='1'"/>
   <xsl:variable name="broadcastclient" select="Attr[@name='BroadcastClient']/@value='1'"/>
   <xsl:text>&gt;/etc/ntp/step-tickers&#10;</xsl:text>
   <xsl:text>echo '# NTP Configuration generated by webshield configuration' &gt; /etc/ntp.conf&#10;</xsl:text>
   <xsl:text>echo disable auth &gt;&gt; /etc/ntp.conf&#10;</xsl:text>

   <xsl:choose>
        <xsl:when test="$enabled='true'">
		 <xsl:text>[[ ! -f $WS_RESTART_LIST ]] || </xsl:text>
		 <xsl:text>/sbin/chkconfig ntpd || </xsl:text>
		 <xsl:text>echo ntpd >>$WS_RESTART_LIST&#10;</xsl:text>
	     <xsl:text>/sbin/chkconfig --level 3 ntpd on&#10;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
	     <xsl:text>/sbin/chkconfig --level 3 ntpd off&#10;</xsl:text>
	     <xsl:text>service ntpd stop&#10;</xsl:text>
             <xsl:text>exit 0&#10;</xsl:text>
        </xsl:otherwise>
   </xsl:choose>   
   <xsl:choose>
        <xsl:when test="$broadcastclient='true'">
           <xsl:text>echo broadcastclient &gt;&gt; /etc/ntp.conf&#10;</xsl:text>
        </xsl:when>
   </xsl:choose>   

   <xsl:for-each select="NetObjectList[@name='NTPServers']/NetObject">
       <xsl:text>echo server </xsl:text><xsl:value-of select="Address/@value"/> <xsl:text>&gt;&gt;/etc/ntp.conf&#10;</xsl:text>
       <xsl:text>echo </xsl:text><xsl:value-of select="Address/@value"/> <xsl:text>&gt;&gt;/etc/ntp/step-tickers&#10;</xsl:text>
   </xsl:for-each>

   <xsl:text>exit 0&#10;</xsl:text>
</xsl:template>
</xsl:stylesheet>

