#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import NewGetStatusOutput
from libwsa import Trace

libwsa.do_trace = False
formatXML = False
REBOOT = '/sbin/reboot'
POWEROFF = '/sbin/poweroff'
DELAYCMD = '(/bin/sleep 10; %s)>/dev/null 2>&1 & :'

def Run():
	global formatXML

	try:
		args, params = libwsa.Init()

		####################################
		# parse the parameters
		####################################
		ctxt = params.xpathNewContext()
		user_file = ctxt.xpathEval("/params/param[@name='user-file']/@value")
		if len(user_file) != 1:
			raise _TR_("WRA_BADUSRFILE", "Invalid user-file parameter")
		user_file = user_file[0].content

		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		# user
		user = ctxt.xpathEval("/command/arg[@name='user']/@value")
		if len(user) != 1:
			raise _TR_("WRA_BADUSR", "Invalid user parameter")
		user = user[0].content
		if user != 'webshield':
			raise _TR_("WRA_WRONGUSR", "Only the user 'webshield' is allowed to restart/reboot the appliance")

		# password
		password = ctxt.xpathEval("/command/arg[@name='password']/@value")
		if len(password) != 1:
			raise _TR_("WRA_BADPASSWORD", "Invalid password parameter")
		password = password[0].content

		# check it
		doIt = libwsa.CheckPassword(user, password, user_file)

		if doIt:
			# reboot ?
			reboot = ctxt.xpathEval("/command/arg[@name='reboot']/@value")
			if len(reboot) != 1:
				raise _TR_("WRA_BADRB", "Invalid reboot parameter")
			try:
				reboot = int(reboot[0].content) != 0
			except Exception:
				raise _TR_("WRA_BADRB", "Invalid reboot parameter")
			####################################
			# let's go
			####################################
			if reboot:
				cmd = REBOOT
				# log it
				libwsa.Log("UI_REBOOT_OR_STOP", "ApplianceRebooted")
			else:
				cmd = POWEROFF
				# log it
				libwsa.Log("UI_REBOOT_OR_STOP", "ApplianceStopped")
			Trace(DELAYCMD % cmd)
			status, msg = NewGetStatusOutput(DELAYCMD % cmd)
			Trace("%s (%d)" % (msg, status))
		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		# add a special output if the password was incorrect
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "password-valid")
		if doIt:
			elt.setProp("value", "1")
		else:
			elt.setProp("value", "0")
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSApplianceStop" id="1">
    <arg name="user" value="webshield"/>
    <arg name="password" value="webshieldchangeme"/>
    <arg name="reboot" value="1"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="user-file" value="/config/wsxmlconf/wsadmin/users.xml"/>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
