#!/usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, time, libxml2, libwsa
from libwsa import _TR_
from libwsa import Trace
from libwsa import NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

ISO_DATETIME = "%Y%m%dT%H%M%S"
try:
	XMLDIR = os.environ["XMLCONFDIR"]
except:
	XMLDIR = '/config/wsxmlconf'

#  FILES[type][component] => path
FILES = { 
	"AV" : { 
		"ENG":os.path.join(XMLDIR, "eng_update_status"),
		"DAT":os.path.join(XMLDIR, "dat_update_status")
		},
	"SPAM" : { 
		"ENG":os.path.join(XMLDIR, "spamengine_update_status"),
		"DAT":os.path.join(XMLDIR, "spamrules_update_status")
		}
	}

# args
#    vars : xml string
#    params : xml string

def Run():
	try:
		####################################
		# parse the arguments
		####################################
		args, params = libwsa.Init()
	
		####################################
		# construct the reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		
		for type, files in FILES.items():
			elt = root.newChild(None, "output", None)
			elt.setProp("name", type)
			for comp, path in files.items():
				content = None
				fmt = None
				try:
					f = open(path)
					content = f.readline()[:-1]
					f.close()
					fmt = os.path.getmtime(path)
					fmt = time.strftime(ISO_DATETIME, time.gmtime(fmt))
				except:
					pass
				child = elt.newChild(None, comp, None)
				if content != None:
					child.setProp("content", content)
				if fmt != None:
					child.setProp("date", fmt)
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	
	except SystemExit:
		pass
	except Exception, details:
		libwsa.PrintError(details)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetComponentsStatus" id="1">
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
