#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, time
from libwsa import _TR_

libwsa.do_trace = False
formatXML = True

def Run():
	global formatXML
	
	# format of the ISO dates
	iso_datetime = "%Y%m%dT%H%M%S"
	# key => result
	cmds = \
		{
		"GMT-TIME" : lambda x : time.strftime(iso_datetime, time.gmtime()),
		"TIMEZONE" : lambda x : time.strftime("%Z"),
		"ENVIRON" : lambda x : x+'='+os.environ.get(x, ''),
		}

	try:
		args, params = libwsa.Init()
	
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
	
		wanted = [ (x.prop("name"), x.prop("value")) for x in ctxt.xpathEval("/command/arg[@name != '']")]
		results = []
		for key, arg in wanted:
			if cmds.has_key(key):
				results.append((key, cmds[key](arg)))

		####################################
		# reply
		####################################
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		for n, v in results:
			elt = root.newChild(None, "output", None)
			elt.setProp("name", n)
			elt.setProp("value", v)
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)
	
def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSGetInfo" id="1">
	<arg name="GMT-TIME"/>	
	<arg name="TIMEZONE"/>	
	<arg name="ENVIRON" value="AVDATDIR"/>	
	<arg name="ENVIRON" value="FOO"/>	
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()


	
