#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re, socket
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
oob = None
PING = "/bin/ping"

def ScriptCallback(res):
	global stdout, stderr, oob
	if res[0] != None:
		stdout += res[0]
		if oob != None:
			oob.write(res[0])
			oob.flush()
	if res[1] != None:
		stderr += res[1]
		if oob != None:
			oob.write(res[1])
			oob.flush()
	return True

def Run():
	global stdout, stderr, formatXML, oob
	try:
		####################################
		# parse the arguments
		####################################			
		args, params = libwsa.Init()

		try:
			oob = os.fdopen(3, 'w')
		except:
			oob = None

		a_ctxt = args.xpathNewContext()
		args = ""
		
		data_size = a_ctxt.xpathEval("/command/arg[@name='data-size']/@value")
		if len(data_size) == 1:
			args += "-s %d " % int(data_size[0].content)

		count = a_ctxt.xpathEval("/command/arg[@name='count']/@value")
		if len(count) == 1:
			args += "-c %d " % int(count[0].content)
		else:
			args += "-c 10 "

		routing = a_ctxt.xpathEval("/command/arg[@name='routing']/@value")
		if len(routing) == 1  and (int(routing[0].content) != 0):
			args += "-R "

		address = a_ctxt.xpathEval("/command/arg[@name='address']/@value")
		if len(address) == 1:
			address = address[0].content
			# first try to resolve the name
			try:
				socket.gethostbyname(address)
			except:
				raise RuntimeError, _TR_("WSNP_IVAD", "Unable to resolve '%s' address") % address
			args += address
		else:
			raise RuntimeError, _TR_("WSNP_NAA", 'No "address" argument')
			
		
		stdout = ""
		stderr = ""
		Trace("Launching '%s %s'" % (PING, args))
		res = libwsa.RunCmd("%s %s" % (PING, args), ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSNP_RFD", 'The ping command failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "pings")
		pings = elt.newChild(None, "pings", None)
		# split the lines
		lines = stdout.splitlines()[1:]
		rePing = re.compile("from\s+(\S+)(\s+\((\d+\.\d+\.\d+\.\d+)\))?\s*:\s+icmp_seq=(\d+)\s+ttl=(\d+)\stime=((\d|\.)+)")
		reRoute = re.compile("(RR)?\s+(.*)\s*$")
		routing = False
		cPing = None
		for l in lines:
			# break on an empty line if it doesn't follow a routing information
			if len(l) == 0 and not routing:
				break
			routing = False
			m = rePing.search(l)
			if (m != None):
				cPing = pings.newChild(None, "ping", None)
				cPing.setProp("route", "")
				if m.groups()[2] != None:
					cPing.setProp("hostname", m.groups()[0])
					cPing.setProp("ip-addr", m.groups()[2])
				else:
					cPing.setProp("hostname", "")
					cPing.setProp("ip-addr", m.groups()[0])
				cPing.setProp("seq-n", m.groups()[3])
				cPing.setProp("ttl", m.groups()[4])
				cPing.setProp("time", m.groups()[5])
			else:
				m = reRoute.search(l)
				if (m != None):
					routing = True
					if cPing != None:
						cPing.setProp("route", cPing.prop("route") + " " + m.groups()[1])
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		raise
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSNetworkPing" id="1">
	<arg name="address" value="172.16.140.175"/>
	<arg name="routing" value="1"/>
	<arg name="data-size" value="164"/>
	<arg name="count" value="5"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()

if __name__ == '__main__':
	Run()
