#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.

import os, sys, libxml2, libwsa, re
from libwsa import _TR_
from libwsa import Trace

libwsa.do_trace = False
formatXML = False

stdout = ""
stderr = ""
ROUTE = "/sbin/route"

def ScriptCallback(res):
	global stdout, stderr
	if res[0] != None:
		stdout += res[0]
	if res[1] != None:
		stderr += res[1]
	return True

def Run():
	global stdout, stderr, formatXML
	try:
		####################################
		# parse the arguments
		####################################			
		args, params = libwsa.Init()

		a_ctxt = args.xpathNewContext()
		args = "-n"
		cache = False
		
		data_size = a_ctxt.xpathEval("/command/arg[@name='cache']/@value")
		if len(data_size) == 1 and int(data_size[0].content) != 0:
			cache = True
			args += " -C"
		
		stdout = ""
		stderr = ""
		Trace("Launching '%s %s'" % (ROUTE, args))
		res = libwsa.RunCmd("%s %s" % (ROUTE, args), ScriptCallback)
		Trace("Done!")
		if res != 0:
			libwsa.PrintErrorBase(_TR_("WSRI_RFD", 'The route command failed'), stdout+"\n"+stderr)
			sys.exit(-1)
		####################################
		# reply
		####################################
		# construct the reply
		reply = libxml2.newDoc("1.0")
		root = reply.newChild(None, "res", None)
		root.setProp("status", "0")
		elt = root.newChild(None, "output", None)
		elt.setProp("name", "routing")
		routing = elt.newChild(None, "routing", None)
		# split the lines and iscard the 2 first
		lines = stdout.splitlines()[2:]
		lParse = re.compile("(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+(\S*)\s*(\d+)\s+(\d+)\s+(\d+)\s+(\S+)")
		cRoute = None
		for l in lines:
			m = lParse.search(l)
			if (m != None):
				cRoute = routing.newChild(None, "route", None)
				if cache:
					cRoute.setProp("src", m.groups()[0])
					cRoute.setProp("dest", m.groups()[1])
					cRoute.setProp("gw", m.groups()[2])
				else:
					cRoute.setProp("dest", m.groups()[0])
					cRoute.setProp("gw", m.groups()[1])
					cRoute.setProp("mask", m.groups()[2])
				cRoute.setProp("flags", m.groups()[3])
				cRoute.setProp("metric", m.groups()[4])
				cRoute.setProp("ref", m.groups()[5])
				cRoute.setProp("use", m.groups()[6])
				cRoute.setProp("iface", m.groups()[7])
		# we're done!
		print root.serialize(format=formatXML)
		sys.exit(0)
	except SystemExit:
		raise
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSNetworkRoute" id="1">
	<arg name="cache" value="1"/>
</command>
	"""
	params = \
	"""
<params>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()

if __name__ == '__main__':
	Run()
