#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa, signal
from libwsa import _TR_, Trace, NewGetStatusOutput

libwsa.do_trace = False
formatXML = False

# the USR1 signal must be relayed
child_pid = None

def InitCallback(pid):
	global child_pid
	child_pid = pid
def SignalHandler(signum, frame):
	global child_pid
	if child_pid != None:
		# relay the signal
		os.kill(child_pid, signum)
signal.signal(signal.SIGUSR1, SignalHandler)
	
# args
#    vars : xml string
#    params : xml string

def Run():
	####################################
	# parse the arguments
	####################################
	try:
		class RCallback:
			def __init__(self):
				self.stdout = ""
				self.stderr = ""
			def Callback(self, res):
				if res[0] != None:
					self.stdout += res[0]
				if res[1] != None:
					self.stderr += res[1]
				return True

		args, params = libwsa.Init()
	
		####################################
		# parse the parameters
		####################################
		ctxt = params.xpathNewContext()
		script_dir = ctxt.xpathEval("/params/param[@name='script-dir']/@value")
		if len(script_dir) != 1:
			raise RuntimeError, _TR_("WSPI_NOSCRDIR", 'Invalid or missing "script-dir" parameter')
		script_dir = script_dir[0].content
		
		####################################
		# parse the arguments
		####################################
		ctxt = args.xpathNewContext()
		
		script = ctxt.xpathEval("/command/arg[@name='script']/@value")
		if len(script) != 1:
			raise RuntimeError, _TR_("WSPI_NOSCR", 'Invalid or missing "script" argument')
		script = script[0].content + ".py"
		# only script in the scripts directory are allowed
		if (os.path.dirname(script) != ''):
			raise RuntimeError, _TR_("WSPI_NOSCR", 'Invalid or missing "script" argument')

		# build the command
		cmd = [os.path.join(script_dir, script)]
		for arg in sys.argv[1:]:
			cmd.append(arg)
			
		output = RCallback()
		Trace("Plug : %s" % cmd)
		status = libwsa.RunCmd(cmd, output.Callback, initCallback=InitCallback)
		Trace("Plug end: (%s) %s" % (status, output.stderr))
		if status != 0:
			raise RuntimeError, _TR_("PLRUN_FAIL", "The command failed (%d)") % status
	
		####################################
		# reply
		####################################
		# we're done!
		print output.stdout
		sys.exit(0)
	
	except SystemExit:
		pass
	except Exception, details:
		libwsa.PrintError(details)
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSPluginRuns" id="1">
    <arg name="script" value="wsp_tcpdump"/>
    <arg name="ports" value=""/>
    <arg name="durationMns" value="2"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="script-dir" value="/opt/NETAwss/ui/wsadmin/scripts"/>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
