#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2003 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from tempfile import mkdtemp
from shutil import copyfile, rmtree
from libwsa import _TR_, Trace

# args
#    vars : xml string
#    params : xml string

libwsa.do_trace = False
formatXML = False

scriptPathApply = '/opt/NETAwss/mgmt/update-xmlconf'
IDX_ID = 0
IDX_REF = 1
IDX_DEST = 2

def ScriptCallback(res):
	# write stdout and stderr on "our" stderr
	if res[0] != None:
		Trace(res[0])
	if res[1] != None:
		Trace(res[1])
	return True

def Run():
	global formatXML
	try:
		dtemp = ""
		try:
			####################################
			# parse the arguments
			####################################
			status = -1
			#doit = False
			#restart = False
			
			args, params = libwsa.Init()
	
			p_ctxt = params.xpathNewContext()
			a_ctxt = args.xpathNewContext()
			
			####################################
			# get the list of files
			####################################
			# files = [[id1, ref1, dest_path1], [id2, ref2, dest_path2], ...]
			files = [ [f.prop('value'), f.prop('ref'), None] for f in a_ctxt.xpathEval("/command/arg[@name='file']")]
			if len(files) == 0:
				raise RuntimeError, _TR_("WSS_FMS", 'No "file" argument(s)')
			####################################
			# get the list of "binary" files
			####################################
			bins = [ [f.prop('value'), f.prop('ref'), None] for f in a_ctxt.xpathEval("/command/arg[@name='others']")]
			####################################
			# Create a temporary directory
			####################################
			dtemp = mkdtemp(dir=libwsa.tmp_dir)
			####################################
			# loop through the files and copy them to their final destination
			####################################
			for f in files:
				if f[IDX_ID] is None or f[IDX_REF] is None:
					raise RuntimeError, _TR_("WSS_FIV", 'Invalid "file" argument(s)')
				dest = p_ctxt.xpathEval("/params/param[@name='file-list']/file[@name='%s']/@path" % f[IDX_ID])
				# get the destination path
				if len(dest) == 0:
					raise RuntimeError, _TR_("WSS_FUNK", 'Unknown "file" argument: %s') % f[IDX_ID]
				f[IDX_DEST] = dest[0].content
				# copy it to the temporary folder
				copyfile(f[IDX_REF], os.path.join(dtemp, os.path.split(f[IDX_DEST])[1]))
			####################################
			####################################
			for f in files:
				Trace("Copying %s into %s" % (f[IDX_REF], f[IDX_DEST]))
				copyfile(f[IDX_REF], f[IDX_DEST])
			cmd = scriptPathApply
			for f in bins:
				cmd += " --%s '%s'" % (f[IDX_ID], f[IDX_REF])
			Trace("Launching '%s >&2'" % cmd)
			libwsa.RunCmd("%s >&2" % cmd, ScriptCallback)
			Trace("Update config done!")
			####################################
			# reply
			####################################
			# construct the reply
			reply = libxml2.newDoc("1.0")
			root = reply.newChild(None, "res", None)
			root.setProp("status", "0")
			output = root.newChild(None, "output", None)
			# we're done!
			print root.serialize(format=formatXML)
			sys.exit(0)
		finally:
			rmtree(dtemp, True)
	except SystemExit:
		pass
	except:
		libwsa.PrintError(sys.exc_info()[1])
		sys.exit(-1)

def Test():
	""" Test function"""
	cmd = \
	"""
<command name="WSPutConfig" id="1">
	<arg name="file" value="webshield" ref="/tmp/WebShield.xml"/>
	<arg name="file" value="access" ref="/tmp/access.xml"/>
	<arg name="others" value="zip" ref="/tmp/tt.zip"/>
</command>
	"""
	params = \
	"""
<params>
	<param name="file-list">
		<file name="webshield" path="/config/wsxmlconf/WebShield.xml"/>
		<file name="rules" path="/config/wsxmlconf/rules.xml"/>
		<file name="policies" path="/config/wsxmlconf/policies.xml"/>
		<file name="access" path="/opt/NETAwss/UI/wsadmin/access.xml"/>
	</param>
</params>
	"""
	sys.argv = [ sys.argv[0], cmd, params ]
	Run()


if __name__ == '__main__':
	Run()
