#!/opt/NETAwss/ui/wsadmin/scripts/surun /usr/bin/python
# Copyright (C) 2004 Networks Associates Technology Inc.
# All rights reserved.
import os, sys, libxml2, libwsa
from libwsa import _TR_
from libwsa import NewGetStatusOutput

BASE_DIR = "/opt/NETAwss/ui/www"
PLUGIN_DIR = os.path.join(BASE_DIR, "plugins")

# check the arguments
sname = os.path.basename(sys.argv[0])
if len(sys.argv) != 2:
	print >>sys.stderr, "%s: %s plugin-name" % (sname, sname)
	sys.exit(-1)
	
plugin_name = sys.argv[1]

# now load the plugin settings files
path = os.path.join(PLUGIN_DIR, plugin_name+".xml")
try:
	pi_settings = libxml2.parseFile(path)
except:
	print >>sys.stderr, "%s : unable to load the plugin settings file (%s)!" % (sname, path)
	sys.exit(-1)

# get the plugin definition
ctxt = pi_settings.xpathNewContext()
pi_node = ctxt.xpathEval("//Plugins/Plugin[@rpm='%s']" % plugin_name)
if len(pi_node) != 1:
	print >>sys.stderr, "%s: Invalid or missing plugin settings!" % (sname)
	sys.exit(-1)
pi_node = pi_node[0]

# now load the global plugin files
path = os.path.join(BASE_DIR, "plugins.xml")
pi_xml = None
if os.path.isfile(path):
	try:
		pi_xml = libxml2.parseFile(path)
		if pi_xml.getRootElement().name != "Plugins":
			pi_xml = None
		else:
			# remove any "previous install"
			ctxt = pi_xml.xpathNewContext()
			prev_nodes = ctxt.xpathEval("//Plugins/Plugin[@rpm='%s']" % plugin_name)
			for n in prev_nodes:
				n.unlinkNode()
	except:
		pass
# first time or need full rewrite
if pi_xml is None:
	pi_xml = libxml2.newDoc("1.0")
	pi_xml.newChild(None, "Plugins", None)
# move the pluigin node to the global doc
pi_node.unlinkNode()
pi_xml.getRootElement().addChild(pi_node)
# save it
try:
	os.chmod(path, 0644)
except:
	pass

pi_xml.saveFile(path)
	
# fix any invalid access rights
NewGetStatusOutput("chown root:apache '%s'" %path)
NewGetStatusOutput("chmod a+r '%s'" %path)
NewGetStatusOutput("chmod ug+w '%s'" %path)

