#!/bin/bash
# Copyright (C) 2004 Networks Associates Technology Inc. All rights reserved.

. /var/NAIENV/.profile.vars

me=${0##*/}

if [[ $# -ne 2 || ! -d $1 || ! -d $2 ]]; then
    printf '%s\n' >&2 \
	"usage:" \
	"$me input_directory output_directory"
    exit 1
fi

tmp=/tmp/$me.$$
trap 'rm -rf "$tmp"' EXIT
mkdir -p "$tmp" || exit

ln -s /opt/NETAwss/avengine/dat/* "$tmp"
ln -s /opt/NETAwss/avengine/lib/liblnxfv.so "$tmp"
ln -s /config/wsxmlconf/smtp.xml "$tmp/policies.xml"
ln -s /config/wsxmlconf/rules.xml "$tmp"
ln -s /opt/NETAeSCM/eplugin/* "$tmp"

cd "$tmp"
./escmenginetest +I "$1" +O "$2" +Y content_out +P "$tmp"
