#! /sbin/sh
# PGP E-ppliance 2.0 Upgrade
#
# FinalBootSunOS5.8.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

ROOTDEV=c0t0d0s0
USRDEV=c0t0d0s3
VARDEV=c0t0d0s6
RESTORESYMFILE="restoresymtable"

FINALBOOTROOT="/root.preserved"
FINALBOOTVAR="/var.preserved"
FINALBOOTUSR="/usr.preserved"
UPGRADEPREFFILE="./.preference"

CONFBACKUPDIR="./Backup/Config"

# clean up the /etc/rcS.d/S99upgrade and /etc/rc3.d/S90report
mount -a > /dev/null 2>&1

if [ -f /etc/rcS.d/S99upgrade ]; then
	 rm -f /etc/rcS.d/S99upgrade > /dev/null 2>&1
fi
if [ -f ${FINALBOOTROOT}/rc3.d/S90report ]; then
	 rm -f ${FINALBOOTROOT}/rc3.d/S90report > /dev/null 2>&1
fi

################################################################################
# functions
################################################################################
RestoreFWConfigs ()
{
	 USRROOT=$1
	 PWD=`pwd`
	 ( cd ${CONFBACKUPDIR}/usr; tar -cf ${USRROOT}/config.tar . )
	 cd ${USRROOT}
	 if [ ! -f config.tar ]; then
		  Log "UPGRADE::ERR Failed to find the firewall configuration backup"
		  Exit 3
	 fi

	 # backup existing files
	 CONFFILELIST=`tar -tvf config.tar | awk '{print $8}'`
	 for CONFFILE in ${CONFFILELIST}; do
		  if [ -f ${CONFFILE} ]; then
				mv -f ${CONFFILE} ${CONFFILE}.PRE2.0.`date '+%Y.%m.%d::%H.%M.%S'` \
					 > /dev/null 2>&1
		  fi
	 done

	 # restore all firewall configuration files
	 tar -xf config.tar > /dev/null 2>&1
	 rm -f config.tar   > /dev/null 2>&1

	 # move the original .profile back
	 mv ${FINALBOOTROOT}/.profile.org ${FINALBOOTROOT}/.profile > /dev/null 2>&1

	 cd ${PWD}
	 return 0
}

# NOTE: calling Exit with non-zero status will cause the system 
# NOTE: restore previous e-ppliance.
Exit ()
{
	 kill $! > /dev/null 2>&1
	 if [ $1 -eq 0 ]; then
		  exit $1
	 fi

	 if [ -z "${UPGRADESTATE}" ] || \
		  [ "${UPGRADESTATE}" != "PGP_UPGRADE_FINALBOOT" ]; then

		  Log "UPGRADE::FATALERR A fatal  upgrade  error  encountered.  The upgrade"
		  Log "UPGRADE::FATALERR must restore your e-ppliance system to pre-upgrade"
		  Log "UPGRADE::FATALERR state by rebooting the system."
		  Log "# Reboot System Back To Pre-upgrade State"

		  SRCPATH="/var/virtmp`pwd`"
		  echo "sh ${SRCPATH}/EMailReport.sh" \
				> /root.preserved/etc/rc3.d/S90report
		  echo "rm -f /etc/rc3.d/S90report" \
				>> /root.preserved/etc/rc3.d/S90report
		  sync; reboot -- "disk:a"
	 fi

	 # if the exit status is non-zero, we need restore previous e-ppliance
	 Log "UPGRADE::FATALERR A fatal  upgrade  error  encountered.  The upgrade"
	 Log "UPGRADE::FATALERR must restore your e-ppliance system to pre-upgrade"
	 Log "UPGRADE::FATALERR state by restoring the whole system."
	 Log "# Restore System Back To Pre-upgrade State"	 
	 sh ./Restore.sh
}

#######################################################################
# define interrupt handling 
# NOTE: upon an interrupt, the upgrade at this stage must bring the
# system back to pre-upgrade state by either reboot disk:a or restore
#######################################################################
trap 'kill $! > /dev/null 2>&1; Log "\n# User Interrupt! Upgrade aborted"; Exit 2' 2 15

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 Exit 3
fi

. ./Utils.sh

Log ""
Log "##########################################################################"
Log "# FinalBoot SunOS-5.8 with EPL2.0 "
Log "##########################################################################"
Log ""

#######################################################################
# load up upgrade preference and state
#######################################################################
Log "# Load Upgrade Preference"
if [ -f ${UPGRADEPREFFILE} ]; then
	 . ${UPGRADEPREFFILE}
else
	 Log "UPGRADE::ERR Failed to find ${UPGRADEPREFFILE}"
	 Exit 3
fi

if [ "${PRODUCT_MODEL}" != "300" ] && [ "${PRODUCT_MODEL}" != "1000" ]; then
	 Log "UPGRADE::ERR Wrong PGP e-ppliance product model found in ${UPGRADEPREFFILE}"
	 Exit 1
fi

#######################################################################
# test if ./gzip is executable
#######################################################################
if [ ! -x ./gzip ]; then
	 Log "UPGRADE::ERR ./gzip not found or not executable"
	 Exit 3
fi

#######################################################################
# change the upgrade state
#######################################################################
if [ ${UPGRADESTATE} = "PGP_UPGRADE_INITBOOT" ] || \
	 [ ${UPGRADESTATE} = "PGP_UPGRADE_FINALBOOT" ]; then
	 UPGRADESTATE="PGP_UPGRADE_FINALBOOT"
	 Export "UPGRADESTATE" ${UPGRADESTATE}
else
	 Log "UPGRADE::ERR Wrong state found in ${UPGRADEPREFFILE}"
	 Exit 1
fi

### CRITICAL ###
#######################################################################
# construct new filesystems /, /var and /usr
#######################################################################
# the root partition
Log "# Construct root Partition"
umount -f ${FINALBOOTROOT} > /dev/null 2>&1
newfs /dev/rdsk/${ROOTDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct root partition."
	 Exit 1
fi
fsck -y -of /dev/rdsk/${ROOTDEV} > /dev/null 2>&1
mount /dev/dsk/${ROOTDEV} ${FINALBOOTROOT}

# the /usr partition
Log "# Construct usr Partition"
umount -f ${FINALBOOTUSR} > /dev/null 2>&1
newfs /dev/rdsk/${USRDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct usr partition."
	 Exit 1
fi
fsck -y -of /dev/rdsk/${USRDEV} > /dev/null 2>&1
mount /dev/dsk/${USRDEV} ${FINALBOOTUSR}

# the /var partition
Log "# Construct var Partition"
umount -f ${FINALBOOTVAR} > /dev/null 2>&1
newfs /dev/rdsk/${VARDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct var partition."
	 Exit 1
fi
fsck -y -of /dev/rdsk/${VARDEV} > /dev/null 2>&1
mount /dev/dsk/${VARDEV} ${FINALBOOTVAR}

#######################################################################
# extract SunOS5.8 + EPL2.0
#######################################################################
sh ./Indicator.sh &

Log "# Extract root Partition"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.root.gz | (cd ${FINALBOOTROOT}; ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ../pgp${PRODUCT_MODEL}.root.gz | ( cd ${FINALBOOTROOT}; tar -xf - ) > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to extract root partition."
	 Exit 1
fi
if [ -f ${FINALBOOTROOT}/${RESTORESYMFILE} ]; then
	 rm -f ${FINALBOOTROOT}/${RESTORESYMFILE}
fi

Log "# Extract var Partition"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.var.gz  | (cd ${FINALBOOTVAR};  ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ../pgp${PRODUCT_MODEL}.var.gz  | (cd ${FINALBOOTVAR};  tar -xf - ) > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to extract var partition."
	 Exit 1
fi
if [ -f ${FINALBOOTVAR}/${RESTORESYMFILE} ]; then
	 rm -f ${FINALBOOTVAR}/${RESTORESYMFILE}
fi

Log "# Extract usr Partition"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.usr.gz  | (cd ${FINALBOOTUSR};  ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ../pgp${PRODUCT_MODEL}.usr.gz  | (cd ${FINALBOOTUSR};  tar -xf - ) > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to extract usr partition."
	 Exit 1
fi
if [ -f ${FINALBOOTUSR}/${RESTORESYMFILE} ]; then
	 rm -f ${FINALBOOTUSR}/${RESTORESYMFILE}
fi

kill $! > /dev/null 2>&1

#######################################################################
# keep the /var/virtmp as a safe upgrade source repository
#######################################################################
Log "# Disable /var/virtmp Clean Routine"
if [ -f ${FINALBOOTUSR}/local/etc/mgmt/cleanse_vtmp.sh ]; then
	 mv ${FINALBOOTUSR}/local/etc/mgmt/cleanse_vtmp.sh \
	 ${FINALBOOTUSR}/local/etc/mgmt/disabled.cleanse_vtmp.sh
fi

#######################################################################
# change /var/spool/mqueue ownership to root
#######################################################################
# this is required only for PGP1000 since /var/spool/mqueue is a
# partition rather than a directory of /var partition on PGP300.
SENDMAILQUEUE="/var/spool/mqueue"
if [ "${PRODUCT_MODEL}" = "1000" ]; then
	 if [ -d "${SENDMAILQUEUE}" ]; then
		  chown root ${SENDMAILQUEUE} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to change ownership of ${SENDMAILQUEUE}"
				Exit 3
		  fi
		  chmod 700 ${SENDMAILQUEUE} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to change access mode of ${SENDMAILQUEUE}"
				Exit 3
		  fi
	 fi
fi

#######################################################################
# ufs filesystems
#######################################################################
Log "# Make ufs Mount Points"
# make /var, /usr, /var/virtmp, and /var/quarantine mount points
mkdir -p ${FINALBOOTROOT}/var
mkdir -p ${FINALBOOTROOT}/usr
mkdir -p ${FINALBOOTROOT}/tmp
mkdir -p ${FINALBOOTVAR}/virtmp
mkdir -p ${FINALBOOTVAR}/quarantine

# make some system mount points
mkdir -p ${FINALBOOTVAR}/run
mkdir -p ${FINALBOOTROOT}/dev/fd
mkdir -p ${FINALBOOTROOT}/proc

# update the /etc/vfstab with the original setting
if [ -f ${FINALBOOTROOT}/etc/vfstab ]; then
	 mv ${FINALBOOTROOT}/etc/vfstab \
	 ${FINALBOOTROOT}/etc/vfstab.PRE2.0
fi
cp ${CONFBACKUPDIR}/etc/vfstab ${FINALBOOTROOT}/etc > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to install system mounting table"
	 Exit 3
fi

#######################################################################
# restore original system user profiles
#######################################################################
# update the /etc/passwd with the original setting
if [ -f ${FINALBOOTROOT}/etc/passwd ]; then
	 mv ${FINALBOOTROOT}/etc/passwd \
	 ${FINALBOOTROOT}/etc/passwd.PRE2.0
fi
cp ${CONFBACKUPDIR}/etc/passwd ${FINALBOOTROOT}/etc > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to restore /etc/passwd"
	 Exit 3
fi

# update the /etc/shadow with the original setting
if [ -f ${FINALBOOTROOT}/etc/shadow ]; then
	 mv ${FINALBOOTROOT}/etc/shadow \
	 ${FINALBOOTROOT}/etc/shadow.PRE2.0
fi
cp ${CONFBACKUPDIR}/etc/shadow ${FINALBOOTROOT}/etc > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to restore /etc/shadow"
	 Exit 3
fi

#######################################################################
# restore original/upgraded configuration data
#######################################################################
Log "# Restore the original firewall configuration files"
RestoreFWConfigs ${FINALBOOTUSR}

#######################################################################
# prepare the final state, in order to set STATE to FIN
#######################################################################
FINALPATH="/var/virtmp`pwd`"
MSGFILE="${FINALPATH}/Finish.sh.$$"
if [ -f ${FINALBOOTROOT}/etc/rc3.d/S99upgrade ]; then
	 rm -f ${FINALBOOTROOT}/etc/rc3.d/S99upgrade
fi
# The MSGFILE file is generated by Finish.sh
# and is sent to the user via e-mail
echo "sh ${FINALPATH}/Finish.sh ${MSGFILE}" \
	 > ${FINALBOOTROOT}/etc/rc3.d/S19upgrade
echo "rm -f /etc/rc3.d/S99upgrade" \
	 >> ${FINALBOOTROOT}/etc/rc3.d/S19upgrade
# Then, the MSGFILE is displayed on screen by
# /etc/rc3.d/S99finish just before the login 
# prompt.
echo "if [ -f "${MSGFILE}" ]; then" \
	 > ${FINALBOOTROOT}/etc/rc3.d/S99finish
echo "\\tcat ${MSGFILE}" \
	 >> ${FINALBOOTROOT}/etc/rc3.d/S99finish
echo "\\trm -f ${MSGFILE}" \
	 >> ${FINALBOOTROOT}/etc/rc3.d/S99finish
echo "fi" \
	 >> ${FINALBOOTROOT}/etc/rc3.d/S99finish
echo "rm -f /etc/rc3.d/S99finish" \
	 >> ${FINALBOOTROOT}/etc/rc3.d/S99finish

#######################################################################
# install the SunOS5.8 boot block into the / partition
#######################################################################
Log "# Install SunOS5.8 Boot Block"
mount -a > /dev/null 2>&1
installboot /usr/platform/`uname -i`/lib/fs/ufs/bootblk \
	 /dev/rdsk/c0t0d0s0

#######################################################################
# init boot from /var/virtmp partition in single user mode
#######################################################################
Log "# Final Reboot from disk:a with PGP ${PRODUCT_MODEL} e-ppliance ${PRODUCT_VERSION}"
sync; reboot -- "disk:a"
# FIN

