#!/bin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# MakeEPLPkg.sh 
#
# Usage:
# % sh MakeEPLPkg.sh [PACK | UPGRADE] destination_path
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

#######################################################################
# Import VARIABLEs
#######################################################################
# FTPSERVER 
# USERNAME 
# PASSWORD 
# BACKUPDIR[ftp] 
# BACKUP_LOGS 
# BACKUP_EMAILS 
# REMOVE_EMAILS 
# BACKUP_EPL
# MQUEUEDIR 
# SMAPQUEUEDIR

#######################################################################
# local variables
#######################################################################
ACTIONTYPE=""
DEST_PATH=""
DEST_PATH_SIZE=""

#######################################################################
# functions
#######################################################################
GetDestPathSize ()
{
	 TMP_DEST_PATH_SIZE=`df -k $DEST_PATH`
	 if [ $? -ne 0 ]; then
		  return 1
	 fi
	 DEST_PATH_SIZE=`echo $TMP_DEST_PATH_SIZE | awk '{ print $11 }'`
}

# return 0 --  succeeded
# return 1 --  failed to transfer file
# return 2 --  the size of file transferred different from the 
#              original one
UploadBackupFile ()
{
# verify the FTP Server if a hostname is given
# TEST=`nslookup theta | grep theta | grep "Name:"` feature

/bin/ftp -n -i ${FTPSERVER}<<EOF
user ${USERNAME} ${PASSWORD}
cd ${BACKUPDIR}
bin
put ${BACKUPSRCFILE} ${BACKUPDSTFILE}
quit
EOF

/bin/ftp -n -i ${FTPSERVER}<<EOF
user ${USERNAME} ${PASSWORD}
cd ${BACKUPDIR}
dir ${BACKUPDSTFILE} /tmp/${BACKUPDSTFILE}.$$
quit
EOF

	 if [ -s /tmp/${BACKUPDSTFILE}.$$ ]; then
		  # get the size of the remote file
		  REMOTE_SIZE=`cat /tmp/${BACKUPDSTFILE}.$$ | awk '{ print $5 }'`
		  # check the size of both files
		  LOCAL_SIZE=`ls -al ${BACKUPSRCFILE} | awk '{ print $5 }'`
		  if [ $LOCAL_SIZE -ne $REMOTE_SIZE ]; then
				return 2
		  fi
	 else
		  return 1
	 fi

	 return 0
}

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

ABSROOT=`pwd`

. ./Utils.sh

#######################################################################
# verify the user's input
#######################################################################
# the user must give the destination_path
if [ $# -eq 2 ]; then
	 ACTIONTYPE=$1
	 if [ "$ACTIONTYPE" != "PACK" ] && [ "$ACTIONTYPE" != "UPGRADE" ]; then
		  Log "UPGRADE::ERR Wrong first argument in MakeEPLPkg.sh"
		  exit 1
	 fi
	 DEST_PATH=$2
else
	 Log "UPGRADE::ERR Wrong argument in MakeEPLPkg.sh"
	 exit 1
fi

#######################################################################
# check the available disk space of the destination_path
#######################################################################
Log "# Validate Available Disk Space"
GetDestPathSize > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to find mount point for $DEST_PATH"
	 exit 2
fi
if [ "$ACTIONTYPE" = "PACK" ]; then
	 if [ $DEST_PATH_SIZE -le 550000 ]; then
		  Log "UPGRADE::ERR Available space $DEST_PATH_SIZE (MB) of $DEST_PATH"
		  Log "UPGRADE::ERR too small to make the upgrade source"
		  exit 2
	 fi
else
	 # the backup size is restricted to 1.0GB ONLY anyway. 
	 if [ $DEST_PATH_SIZE -le 1000000 ]; then
		  Log "UPGRADE::ERR Available space $DEST_PATH_SIZE (MB) of $DEST_PATH"
		  Log "UPGRADE::ERR too small to backup the e-ppliance system"
		  exit 2
	 fi
fi

#######################################################################
# test if ./gzip is executable
#######################################################################
if [ ! -x ./gzip ]; then
	 Log "UPGRADE::ERR ./gzip not found or not executable"
	 exit 3
fi

# enable interrupt 
trap 'kill $! > /dev/null 2>&1' 0
trap 'kill $! > /dev/null 2>&1; Log "\n# User Interrupt! Upgrade aborted"; exit 2' 2 15
sh ./Indicator.sh &
#######################################################################
# /var partition 
#######################################################################
# ufsdump the /var partition
# /var/log          -- backup them separately first, send the backup 
#                      somewhere else, then remove the backup
# /var/spool/smap   -- if fits in the backup, back them up. otherwise 
#                      ask the user. 
# /var/spool/mqueue -- if fits in the backup, back them up. otherwise 
#                      ask the user.
if [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 # backup log files and transfer to an FTP server
	 if [ "$BACKUP_LOGS" = "TRUE" ]; then
		  Log "# Upload Firewall Logs to ${FTPSERVER}"
		  LOGBACKUPNAME=pgp${PRODUCT_MODEL}.log.PRE_EPL2.0.gz
		  BACKUPSRCFILE=${DEST_PATH}/${LOGBACKUPNAME}
		  ## ufsdump 0f - /var/log 2>/dev/null | ./gzip > ${BACKUPSRCFILE}
		  ( cd / ; tar -cf - ./var/log 2>/dev/null | ${ABSROOT}/gzip > ${BACKUPSRCFILE} )
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to backup firewall logging files in /var/log"
				exit 3
		  fi		  

		  # FTP the backup of logs to a remote server
		  BACKUPDSTFILE="`hostname`.${LOGBACKUPNAME}"
		  UploadBackupFile > /dev/null 2>&1

		  UPLOADSTATUS="$?"
		  case "$UPLOADSTATUS" in
		  0)
				# remove the logging backup
				rm -f "$BACKUPSRCFILE" > /dev/null 2>&1
				if [ $? -ne 0 ]; then
					 Log "UPGRADE::ERR Failed to remove $BACKUPSRCFILE"
					 exit 3
				fi
				;;
		  1)
				Log "UPGRADE::ERR Failed to upload ${BACKUPSRCFILE} to ${FTPSERVER}"
				exit 4
				;;
		  2)
				Log "UPGRADE::ERR Different size of ${BACKUPSRCFILE} found on ${FTPSERVER}"
				exit 5
				;;
		  *)
				Log "UPGRADE::ERR Unknown error found while uploading ${BACKUPSRCFILE} to ${FTPSERVER}"
				exit 6
		  esac
	 fi
fi

# remove all backup log files in /var/log and shrink 
# all logging files
if [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 Log "# Remove Firewall Logs from Local System"
fi
if [ -d /var/log ]; then
	 CURRDIR=`pwd`
	 cd /var/log
	 LOGFILES=`ls | grep '\([0-9]\)'`
	 if [ -n "${LOGFILES}" ]; then
		  rm ${LOGFILES} > /dev/null 2>&1
	 fi
	 
	 LOGFILES=`ls`
	 for logfile in $LOGFILES; do
		  cp /dev/null $logfile > /dev/null 2>&1
	 done
	 cd ${CURRDIR}
fi

if [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 # backup queued e-mails / transfer to an FTP server
	 # the user is asked this option only when the size of queued messages
	 # excceds the backup space limit which is 1.0GB in total
	 if [ "${BACKUP_EMAILS}" = "TRUE" ] || [ "${REMOVE_EMAILS}" = "FALSE" ]; then
		  Log "# Backup Firewall Queued E-Mails"
		  EMAILBACKUPNAME=pgp${PRODUCT_MODEL}.mail.PRE_EPL2.0.gz
		  BACKUPSRCFILE=${DEST_PATH}/${EMAILBACKUPNAME}
		  ## ufsdump 0f - ${MQUEUEDIR} ${SMAPQUEUEDIR} 2>/dev/null | ./gzip > ${BACKUPSRCFILE}
		  ( cd /var ; tar -cf - ./spool/mqueue ./spool/smap 2>/dev/null | ${ABSROOT}/gzip > ${BACKUPSRCFILE} )
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to backup firewall queued e-mails"
				exit 3
		  fi
	 fi

	 # if BACKUP_EMAILS is TRUE, then the REMOVE_EMAILS must be TRUE
	 if [ "${BACKUP_EMAILS}" = "TRUE" ]; then
		  Log "# Upload Firewall Queued EMails to ${FTPSERVER}"
		  # FTP the backup of queued emails to a remote server
		  BACKUPDSTFILE="`hostname`.${EMAILBACKUPNAME}"
		  UploadBackupFile > /dev/null 2>&1

		  UPLOADSTATUS="$?"
		  case "$UPLOADSTATUS" in
		  0)
				# remove the queued e-mail backup
				rm -f "$BACKUPSRCFILE"
				if [ $? -ne 0 ]; then
					 Log "UPGRADE::ERR Failed to remove $BACKUPSRCFILE"
					 exit 3
				fi
				;;
		  1)
				Log "UPGRADE::ERR Failed to upload ${BACKUPSRCFILE} to ${FTPSERVER}"
				exit 4
				;;
		  2)
				Log "UPGRADE::ERR Different size of ${BACKUPSRCFILE} found on ${FTPSERVER}"
				exit 5
				;;
		  *)
				Log "UPGRADE::ERR Unknown error found while uploading ${BACKUPSRCFILE} to ${FTPSERVER}"
				exit 6
		  esac
	 fi
	 
	 # remove the queued emails		  
	 Log "# Remove Firewall Queued E-Mails"
	 rm -rf ${MQUEUEDIR}/* 
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to remove ${MQUEUEDIR}"
		  exit 3
	 fi
	 rm -rf ${SMAPQUEUEDIR}/*
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to remove ${SMAPQUEUEDIR}"
		  exit 3
	 fi
fi

# backup/pack all the rest in /var partition
VARPATNAME=""
if [ "$ACTIONTYPE" = "PACK" ]; then
	 Log "# Pack var Partition"
	 VARPATNAME=pgp${PRODUCT_MODEL}.var.gz
else
	 Log "# Backup var Partition"
	 VARPATNAME=pgp${PRODUCT_MODEL}.var.PRE_EPL2.0.gz
fi
BACKUPSRCFILE=${DEST_PATH}/${VARPATNAME}
		  
## ufsdump 0f - /dev/dsk/c0t0d0s6 2>/dev/null | ./gzip > ${BACKUPSRCFILE}
( cd /var ; tar -cfX - ${ABSROOT}/var.exc . 2>/dev/null | ${ABSROOT}/gzip > ${BACKUPSRCFILE} )
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to pack firewall /var partition"
	 exit 3
fi
	 
if [ "$BACKUP_EPL" = "TRUE" ] && [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 # FTP the backup of var partition to a remote server
	 Log "# Upload var Partition to ${FTPSERVER}"
	 BACKUPDSTFILE="`hostname`.${VARPATNAME}"
	 UploadBackupFile > /dev/null 2>&1

	 UPLOADSTATUS="$?"
	 case "$UPLOADSTATUS" in
	 0)
		  ;;
	 1)
		  Log "UPGRADE::ERR Failed to upload ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 4
		  ;;
	 2)
		  Log "UPGRADE::ERR Different size of ${BACKUPSRCFILE} found on ${FTPSERVER}"
		  exit 5
		  ;;
	 *)
		  Log "UPGRADE::ERR Unknown error found while uploading ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 6
	 esac
fi

#######################################################################
# root partition 
#######################################################################
# ufsdump the root partition
ROOTPATNAME=""
if [ "$ACTIONTYPE" = "PACK" ]; then
	 Log "# Pack root Partition"
	 ROOTPATNAME=pgp${PRODUCT_MODEL}.root.gz
else
	 Log "# Backup root Partition"
	 ROOTPATNAME=pgp${PRODUCT_MODEL}.root.PRE_EPL2.0.gz
fi
BACKUPSRCFILE=${DEST_PATH}/${ROOTPATNAME}

## ufsdump 0f - /dev/dsk/c0t0d0s0 2>/dev/null | ./gzip > ${BACKUPSRCFILE}
( cd / ; tar -cfX - ${ABSROOT}/root.exc . 2>/dev/null | ${ABSROOT}/gzip > ${BACKUPSRCFILE} )
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to pack firewall root partition"
	 exit 3
fi		  
 
if [ "$BACKUP_EPL" = "TRUE" ] && [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 # FTP the backup of root partition to a remote server
	 Log "# Upload root Partition to ${FTPSERVER}"
	 BACKUPDSTFILE="`hostname`.${ROOTPATNAME}"
	 UploadBackupFile > /dev/null 2>&1

	 UPLOADSTATUS="$?"
	 case "$UPLOADSTATUS" in
	 0)
		  ;;
	 1)
		  Log "UPGRADE::ERR Failed to upload ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 4
		  ;;
	 2)
		  Log "UPGRADE::ERR Different size of ${BACKUPSRCFILE} found on ${FTPSERVER}"
		  exit 5
		  ;;
	 *)
		  Log "UPGRADE::ERR Unknown error found while uploading ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 6
	 esac
fi

#######################################################################
# /usr partition 
#######################################################################
# ufsdump the /usr partition 
# the /usr partition only contains /usr directory
USRPATNAME=""
if [ "$ACTIONTYPE" = "PACK" ]; then
	 Log "# Pack usr Partition"
	 USRPATNAME=pgp${PRODUCT_MODEL}.usr.gz
else
	 Log "# Backup usr Partition"
	 USRPATNAME=pgp${PRODUCT_MODEL}.usr.PRE_EPL2.0.gz
fi
BACKUPSRCFILE=${DEST_PATH}/${USRPATNAME}

## ufsdump 0f - /dev/dsk/c0t0d0s3 2>/dev/null | ./gzip > ${BACKUPSRCFILE}
( cd /usr ; tar -cfX - ${ABSROOT}/usr.exc . 2>/dev/null | ${ABSROOT}/gzip > ${BACKUPSRCFILE} )
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to pack firewall usr partition"
	 exit 3
fi		  
 
if [ "$BACKUP_EPL" = "TRUE" ] && [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 # FTP the backup of root partition to a remote server
	 Log "# Upload usr Partition to ${FTPSERVER}"
	 BACKUPDSTFILE="`hostname`.${USRPATNAME}"
	 UploadBackupFile > /dev/null 2>&1

	 UPLOADSTATUS="$?"
	 case "$UPLOADSTATUS" in
	 0)
		  ;;
	 1)
		  Log "UPGRADE::ERR Failed to upload ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 4
		  ;;
	 2)
		  Log "UPGRADE::ERR Different size of ${BACKUPSRCFILE} found on ${FTPSERVER}"
		  exit 5
		  ;;
	 *)
		  Log "UPGRADE::ERR Unknown error found while uploading ${BACKUPSRCFILE} to ${FTPSERVER}"
		  exit 6
	 esac
fi

kill $!

# enable interrupts
trap 0 2 15

#######################################################################
# finish
#######################################################################
Log "UPGRADE::MSG PGP e-ppliance source image has been generated"
Log "UPGRADE::MSG successfully in ${DEST_PATH}"
exit 0
