#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# UpgradeConfig.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

CONFBACKUPDIR="`pwd`/Backup/Config"

#######################################################################
# verify the backup of the configuration data
#######################################################################
if [ ! -d "${CONFBACKUPDIR}" ]; then
	 Log "UPGRADE::ERR Failed to find the backup of e-ppliance configuration"
	 exit 3
fi

# make a subdirectory "./data" and store all necessary files there
CONFDATADIR="./data"
if [ ! -d "${CONFDATADIR}" ]; then
	 mkdir -p ${CONFDATADIR} > /dev/null 2>&1
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to make directory ${CONFDATADIR}"
		  exit 3
	 fi
fi

# extract configuration files for upgrade
# gauntlet.conf,
# keys.conf 
# gvpn_cert_status.conf 
# initial_env

# gauntlet.conf
# always fetch the latest gauntlet.conf from /usr/local/etc/mgmt
if [ -f /usr/local/etc/mgmt/gauntlet.conf ]; then
	 cp /usr/local/etc/mgmt/gauntlet.conf \
		  ${CONFBACKUPDIR}/usr/local/etc/mgmt > /dev/null 2>&1
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to fetch gauntlet.conf file from /usr/local/etc/mgmt"
		  exit 3
	 fi
else
	 Log "UPGRADE::ERR Failed to find gauntlet.conf file in /usr/local/etc/mgmt"
	 exit 3
fi
cp ${CONFBACKUPDIR}/usr/local/etc/mgmt/gauntlet.conf ${CONFDATADIR} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to copy gauntlet.conf file"
	 exit 3
fi
# keys.conf
if [ -f ${CONFBACKUPDIR}/usr/local/etc/mgmt/keys.conf ]; then
	 cp ${CONFBACKUPDIR}/usr/local/etc/mgmt/keys.conf ${CONFDATADIR} > /dev/null 2>&1
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to copy keys.conf file"
		  exit 3
	 fi
fi
# gvpn_cert_status.conf
if [ -f ${CONFBACKUPDIR}/usr/local/etc/mgmt/upgrade/gvpn_cert_status.conf ]; then
	 cp ${CONFBACKUPDIR}/usr/local/etc/mgmt/upgrade/gvpn_cert_status.conf \
		  ${CONFDATADIR} > /dev/null 2>&1
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to copy gvpn_cert_status.conf file"
		  exit 3
	 fi
fi
# initial_env
cp ./usr/local/etc/mgmt/menus/initial_env ${CONFDATADIR} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to copy initial_env file"
	 exit 3
fi

#######################################################################
# upgrade the configuration
#######################################################################
# check to see if ./data has gauntlet.conf, initial_env and 1xTo20.tpl
if [ ! -f ${CONFDATADIR}/gauntlet.conf ] || \
	 [ ! -f ${CONFDATADIR}/initial_env ] || \
	 [ ! -f ${CONFDATADIR}/1xTo20.tpl ]; then
	 Log "UPGRADE::ERR Some essential configuration upgrade files missing"
	 exit 3
fi

if [ ! -x ${CONFDATADIR}/configupgrade ]; then
	 Log "UPGRADE::ERR ${CONFDATADIR}/configupgrade not found or not executable"
	 exit 3
fi

# upgrade the configuration files
PWD=`pwd`
cd ${CONFDATADIR}
./configupgrade > /dev/null 2>&1 
if [ $? -ne 0 ]; then
	 cd ${PWD}
	 Log "UPGRADE::FATALERR Failed to upgrade firewall configuration data"
	 exit 3
fi

cd ${PWD}

# once done, put the final gaunlet.conf ./usr/local/etc/mgmt
if [ ! -f ${CONFDATADIR}/gauntlet.conf.new.out ]; then
	 Log "UPGRADE::FATALERR Failed to find the output of gauntlet.conf"
	 exit 3
fi

# save the previous gauntlet.conf as gauntlet.conf.PRE2.0
mv -f ${CONFBACKUPDIR}/usr/local/etc/mgmt/gauntlet.conf \
	 ${CONFBACKUPDIR}/usr/local/etc/mgmt/gauntlet.conf.PRE2.0.`date '+%Y.%m.%d::%H.%M.%S'` \
	 > /dev/null 2>&1

cp ${CONFDATADIR}/gauntlet.conf.new.out \
	 ${CONFBACKUPDIR}/usr/local/etc/mgmt/gauntlet.conf \
	 > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::FATALERR Failed to copy final firewall configuration"
	 exit 3
fi

#######################################################################
# finish
#######################################################################
exit 0
