#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# VerifySystem.sh [UPGRADE | PACK]
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

# ACTIONTYPE: UPGRADE/PACK

################################################################################
# local variables
################################################################################
ACTIONTYPE=""

EPL_ROOT_PATH="/usr/local/etc"
EPL_CONFIG_FILE="$EPL_ROOT_PATH/mgmt/gauntlet.conf"
EPL_LOG_PATH="/var/log"

ROOT_DEV="/dev/dsk/c0t0d0s0"
TMP_DEV="swap"
USR_DEV="/dev/dsk/c0t0d0s3"
VAR_QUA_DEV="/dev/dsk/c0t0d0s4"
VAR_VIR_DEV="/dev/dsk/c0t0d0s5"
VAR_DEV="/dev/dsk/c0t0d0s6"

SMAPQUEUE_USAGE=0
MQUEUE_USAGE=0
DSK_USEDSIZE=0

################################################################################
# functions
################################################################################
ShowHugeFiles ()
{	 
	 COUNT=0
	 while [ true ]; do		  
		  if [ $COUNT -eq 0 ]; then
				AGAIN=""
		  else
				AGAIN=" again"
		  fi
		  echo ""
		  echo "Would you like the upgrade list all huge files in your system${AGAIN}? [y/n] : \c"
		  read foo
		  if [ "${foo}" != "y" -a "${foo}" != "Y" ]; then
				return 0
		  fi
		  echo ""
		  echo "Please enter the size of huge files [KB] : \c"
		  read foo
		  FindHugeFiles / $foo
		  FindHugeFiles /usr $foo
		  FindHugeFiles /var $foo
		  COUNT=`expr $COUNT + 1`
	 done
	 return 0
}

# verify the disk partition layout
# arg1 -- device name
# arg2 -- mount point
# arg3 -- size
VerifyDiskPartition ()
{
	 TMP_DISK_PART_INFO=`df -k | grep "$1"`
	 if [ -z "${TMP_DISK_PART_INFO}" ]; then
		  Log "UPGRADE::ERR Failed to find UFS filesystem of $1"
		  exit 3
	 fi
	 TMP_DSK_MNT=`echo $TMP_DISK_PART_INFO | awk '{ print $6 }'`
	 if [ "$TMP_DSK_MNT" != "$2" ]; then
		  Log "UPGRADE::ERR $2 partition must be mounted on $1"
		  exit 3
	 fi
	 
	 if [ "$ACTIONTYPE" = "UPGRADE" ]; then 
		  TMP_DSK_SIZE=`echo $TMP_DISK_PART_INFO | awk '{ print $2 }'`
		  if [ $TMP_DSK_SIZE -le $3 ]; then
				Log "UPGRADE::ERR $2 partition size must be greater than $3 KB"
				exit 3
		  fi
	 
		  # for root, usr and var partition, calculate the disk total usage
		  # for the var partition, the /var/log must be exculuded
		  if [ "$1" = "$ROOT_DEV" ] || [ "$1" = "$USR_DEV" ] || [ "$1" = "$VAR_DEV" ]; then
				TMP_DSK_USEDSIZE=`echo $TMP_DISK_PART_INFO | awk '{ print $3 }'`
				if [ "$1" = "$VAR_DEV" ]; then
					 TMP_LOG_SIZE=`du -dsk $EPL_LOG_PATH | awk '{ print $1 }'`
					 TMP_DSK_USEDSIZE=`expr $TMP_DSK_USEDSIZE - $TMP_LOG_SIZE`

					 SMAPQUEUE_USAGE=`du -dks ${SMAPQUEUEDIR} | awk '{ print $1 }'`
					 TMP_DSK_USEDSIZE=`expr $TMP_DSK_USEDSIZE - $SMAPQUEUE_USAGE`
					
					 MQUEUE_USAGE=`du -dks ${MQUEUEDIR} | awk '{ print $1 }'`
					 TMP_DSK_USEDSIZE=`expr $TMP_DSK_USEDSIZE - $MQUEUE_USAGE`
				fi
				DSK_USEDSIZE=`expr $DSK_USEDSIZE + $TMP_DSK_USEDSIZE`
		  fi
	 
		  # for /var/virtmp and /tmp partition, check the avail disk space
		  # /var/virtmp should consider the size of upgrade package
		  if [ "$1" = "$VAR_VIR_DEV" ]; then
				TMP_DSK_AVAILSIZE=`echo $TMP_DISK_PART_INFO | awk '{ print $4 }'`
				if [ $TMP_DSK_AVAILSIZE -le 2400000 ]; then
					 Log "UPGRADE::ERR Found insufficient available disk space in partition of $2"
					 exit 3
				fi
		  fi
		  if [ "$1" = "$TMP_DEV" ]; then
				TMP_DSK_AVAILSIZE=`echo $TMP_DISK_PART_INFO | awk '{ print $4 }'`
				if [ $TMP_DSK_AVAILSIZE -le 920000 ]; then
					 Log "UPGRADE::ERR Found insufficient available disk space in partition of $2"
					 exit 3
				fi
		  fi
	 fi

	 return 0
}

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

#######################################################################
# verify the user's input
#######################################################################
if [ $# -eq 1 ]; then
	 ACTIONTYPE=$1
else
	 Log "UPGRADE::ERR Wrong argument in VerifySystem.sh"
	 exit 1
fi

if [ "$ACTIONTYPE" != "PACK" ] && [ "$ACTIONTYPE" != "UPGRADE" ]; then
	 Log "UPGRADE::ERR Wrong argument in VerfiySystem.sh"
	 exit 1
fi

################################################################################
# verify the existing PGP e-ppliance version 
################################################################################
if [ "${ACTIONTYPE}" = "UPGRADE" ]; then
	 if [ ! -f "$EPL_CONFIG_FILE" ]; then
		  Log "UPGRADE::ERR Failed to find an existing PGP e-ppliance product"
		  Log "UPGRADE::ERR on the system. The upgrade is designated to upgrade"
		  Log "UPGRADE::ERR PGP e-ppliance 1.5 to 2.0."
		  exit 3
	 fi
fi

if [ ! -x "$EPL_ROOT_PATH/gversion" ]; then
	 Log "UPGRADE::ERR Failed to identify the version of the existing"
	 Log "UPGRADE::ERR PGP e-ppliance product."
	 exit 3
fi

EPL_VERSION=`$EPL_ROOT_PATH/gversion`
if [ "$ACTIONTYPE" = "UPGRADE" ]; then
	 if [ "$EPL_VERSION" != "V1.5" ]; then
		  Log "UPGRADE::ERR Found unsupported PGP e-ppliance version ${EPL_VERSION}"
		  Log "UPGRADE::ERR The upgrade is designated to upgrade PGP e-ppliance 1.5 to 2.0."
		  exit 3
	 fi
else
	 # NOTE: some e-ppliance 2.0 may have 6.0 version number
	 if [ "$EPL_VERSION" != "2.0" ]; then
		  Log "UPGRADE::ERR Found unsupported PGP e-ppliance version ${EPL_VERSION}"
		  exit 3
	 fi
fi

################################################################################
# validation of the e-ppliance system OS platform
################################################################################
# OS platform must be SunOS-5.8 with the architecture
# SUNW,UltraSPARC-IIi-cEngine for 300
# SUNW,Ultra-80               for 1000
# and must be 32-bit
if [ ${ACTIONTYPE} = "PACK" ]; then
	 OSVER="SunOS-5.8"
else
	 OSVER="SunOS-5.6"
fi
SUNOSPLATFORM=`uname -s -r | tr " " "-"`
if [ "${SUNOSPLATFORM}" != "${OSVER}" ]; then
	 Log "UPGRADE::ERR Unsupported OS version $SUNOSPLATFORM"
	 Log "UPGRADE::ERR PGP $PRODUCT_MODEL e-ppliance 2.0 must run on ${OSVER} operating system"
	 exit 3
fi
SUNOSPLATFORM=`uname -i`
if [ "${PRODUCT_MODEL}" = "300" ] && [ "$SUNOSPLATFORM" != "SUNW,UltraSPARC-IIi-cEngine" ]; then
	 Log "UPGRADE::ERR Unsupported architecture $SUNOSPLATFORM"
	 Log "UPGRADE::ERR PGP $PRODUCT_MODEL e-ppliance 2.0 must run on SUNW,UltraSPARC-IIi-cEngine architecture"
	 exit 3
fi
if [ "${PRODUCT_MODEL}" = "1000" ] && [ "$SUNOSPLATFORM" != "SUNW,Ultra-80" ]; then
	 Log "UPGRADE::ERR Unsupported architecture $SUNOSPLATFORM"
	 Log "UPGRADE::ERR PGP $PRODUCT_MODEL e-ppliance 2.0 must run on SUNW,Ultra-80 architecture"
	 exit 3
fi
if [ ${ACTIONTYPE} = "PACK" ]; then
	 SUNOSPLATFORM=`isainfo -b`
	 if [ "$SUNOSPLATFORM" != 32 ]; then
		  Log "UPGRADE::ERR Unsupported $SUNOSPLATFORM-bit instruction set"
		  Log "UPGRADE::ERR PGP $PRODUCT_MODEL e-ppliance 2.0 supports only 32-bit instruction set"
		  exit 3
	 fi
fi

################################################################################
# validation of the e-ppliance file systems
################################################################################
# check the disk partition and partition size
# Filesystem            kbytes   avail  Mounted on      checksize   
# /dev/dsk/c0t0d0s0     120739   84948  /               >  120000   
# swap                 1072315  695691  /tmp            > 1070000  
# /dev/dsk/c0t0d0s3     918799  328163  /usr            >  910000  
# /dev/dsk/c0t0d0s4      86533   77871  /var/quarantine >   80000  
# /dev/dsk/c0t0d0s5    3009594 1722256  /var/virtmp     > 3000000 
# /dev/dsk/c0t0d0s6    3408466 3252785  /var            > 3300000 

# root partition
VerifyDiskPartition ${ROOT_DEV} "/" 120000

# /tmp partition
if [ "$ACTIONTYPE" != "PACK" ]; then
	 VerifyDiskPartition ${TMP_DEV} "/tmp" 1070000
fi

# /usr partition
# NOTE: since the SunOS5.8 doesn't show the /usr
#       partition well, the validation on this
#       partition would fail always
if [ "$ACTIONTYPE" != "PACK" ]; then
	 VerifyDiskPartition ${USR_DEV} "/usr" 910000
fi

# /var/quarantine partition
VerifyDiskPartition ${VAR_QUA_DEV} "/var/quarantine" 80000

# /var/virtmp partition
VerifyDiskPartition ${VAR_VIR_DEV} "/var/virtmp" 3000000

# /var partition
VerifyDiskPartition ${VAR_DEV} "/var" 3300000

# check the avail disk space for upgrade
# if the used space of root, /usr and /var exceeds 1.0GB, [700MB for baseline]
# warn the user clean some data from the e-ppliance
if [ "$ACTIONTYPE" = "UPGRADE" ]; then 
	 if [ $DSK_USEDSIZE -gt 1000000 ]; then
		  Log "UPGRADE::ERR Disk usage (excluding /var/log,  queued e-mails)  of"
		  Log "UPGRADE::ERR root, /usr and /var is $DSK_USEDSIZE KB, which is "
		  Log "UPGRADE::ERR greater than 1.0GB. The upgrade could fail to backup"
		  Log "UPGRADE::ERR the existing PGP e-ppliance."
		  Log "UPGRADE::ERR The  upgrade  now  is  aborted.  Please  remove  any"
		  Log "UPGRADE::ERR unnecessary files from the system, then perform  the"
		  Log "UPGRADE::ERR upgrade again."
		  ShowHugeFiles
		  exit 7
	 fi
	 DSK_USEDSIZE_W_EMAILS=`expr $DSK_USEDSIZE + $MQUEUE_USAGE + $SMAPQUEUE_USAGE`
	 if [ $DSK_USEDSIZE_W_EMAILS -gt 1000000 ]; then
		  exit 8
	 fi
fi

################################################################################
# finish
################################################################################
exit 0

